/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.BlockEntityDataUtil;
import net.pitan76.mcpitanlib.api.util.BlockEntityTypeUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class BlockEntityUtil {
    public static TileEntity getBlockEntity(World world, BlockPos pos) {
        return WorldUtil.getBlockEntity(world, pos);
    }

    public static CompoundNBT getBlockEntityNbt(@Nullable World world, TileEntity blockEntity) {
        CompoundNBT nbt = NbtUtil.create();
        return blockEntity.func_189515_b(nbt);
    }

    public static CompoundNBT getBlockEntityNbt(TileEntity blockEntity) {
        return BlockEntityUtil.getBlockEntityNbt(null, blockEntity);
    }

    public static World getWorld(TileEntity blockEntity) {
        return blockEntity.func_145831_w();
    }

    public static boolean hasWorld(TileEntity blockEntity) {
        return blockEntity.func_145830_o();
    }

    public static BlockPos getPos(TileEntity blockEntity) {
        return blockEntity.func_174877_v();
    }

    public static BlockState getCachedState(TileEntity blockEntity) {
        return blockEntity.func_195044_w();
    }

    public static BlockState getBlockState(TileEntity blockEntity) {
        return BlockEntityUtil.getWorld(blockEntity).func_180495_p(BlockEntityUtil.getPos(blockEntity));
    }

    public static Block getBlock(TileEntity blockEntity) {
        return BlockEntityUtil.getBlockState(blockEntity).func_177230_c();
    }

    public static void markRemoved(TileEntity blockEntity) {
        blockEntity.func_145843_s();
    }

    public static void markDirty(TileEntity blockEntity) {
        blockEntity.func_70296_d();
    }

    public static TileEntityType<?> getType(TileEntity blockEntity) {
        return blockEntity.func_200662_C();
    }

    public static void readNbt(TileEntity blockEntity, CompoundNBT nbt, CompatRegistryLookup registryLookup) {
        blockEntity.func_230337_a_(blockEntity.func_195044_w(), nbt);
    }

    public static void writeNbt(TileEntity blockEntity, CompoundNBT nbt, CompatRegistryLookup registryLookup) {
        blockEntity.func_189515_b(nbt);
    }

    public static void read(TileEntity blockEntity, CompoundNBT nbt, CompatRegistryLookup registryLookup) {
        blockEntity.func_230337_a_(blockEntity.func_195044_w(), nbt);
    }

    public static CompoundNBT createNbt(TileEntity blockEntity, CompatRegistryLookup registryLookup) {
        CompoundNBT nbt = NbtUtil.create();
        BlockEntityUtil.writeNbt(blockEntity, nbt, registryLookup);
        return nbt;
    }

    public static void setStackNbt(TileEntity blockEntity, ItemStack stack, CompatRegistryLookup registryLookup) {
        blockEntity.func_189515_b(stack.func_77978_p());
    }

    public static ServerWorld getServerWorld(TileEntity blockEntity) {
        return (ServerWorld)BlockEntityUtil.getWorld(blockEntity);
    }

    public static void writeToStack(ItemStack stack, TileEntity blockEntity, CompatRegistryLookup registryLookup) {
        CompoundNBT nbt = BlockEntityUtil.getBlockEntityNbt(blockEntity);
        if (!NbtUtil.has(nbt, "id")) {
            NbtUtil.putString(nbt, "id", BlockEntityTypeUtil.toID(BlockEntityUtil.getType(blockEntity)).toString());
        }
        BlockEntityDataUtil.setBlockEntityNbt(stack, nbt);
    }
}

