/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.sound.CompatBlockSoundGroup;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.block.BlockHitResultUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.world.BlockView;

public class BlockStateUtil {
    public static Block getBlock(net.minecraft.block.BlockState state) {
        return state.func_177230_c();
    }

    public static boolean isAir(net.minecraft.block.BlockState state) {
        return state.func_196958_f();
    }

    public static boolean isOpaque(net.minecraft.block.BlockState state) {
        return state.func_200132_m();
    }

    public static SoundType getSoundGroup(net.minecraft.block.BlockState state) {
        return state.func_215695_r();
    }

    public static CompatBlockSoundGroup getCompatSoundGroup(net.minecraft.block.BlockState state) {
        return CompatBlockSoundGroup.of(BlockStateUtil.getSoundGroup(state));
    }

    public static net.minecraft.block.BlockState getDefaultState(Block block) {
        return block.func_176223_P();
    }

    public static StateContainer<Block, net.minecraft.block.BlockState> getStateManager(Block block) {
        return block.func_176194_O();
    }

    public static <T extends Comparable<T>, V extends T> net.minecraft.block.BlockState with(net.minecraft.block.BlockState state, Property<T> property, V value) {
        return (net.minecraft.block.BlockState)state.func_206870_a(property, value);
    }

    public static void neighborUpdate(net.minecraft.block.BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        state.func_215697_a(world, pos, block, fromPos, notify);
    }

    public static void updateNeighbors(net.minecraft.block.BlockState state, IWorld world, BlockPos pos, int flags) {
        state.func_235734_a_(world, pos, flags);
    }

    public static boolean hasRandomTicks(net.minecraft.block.BlockState state) {
        return state.func_204519_t();
    }

    public static void randomTick(net.minecraft.block.BlockState state, ServerWorld world, BlockPos pos) {
        state.func_227034_b_(world, pos, world.field_73012_v);
    }

    public static CompatActionResult onUse(net.minecraft.block.BlockState state, World world, Player player, BlockRayTraceResult hitResult) {
        Hand hand = player.getMainHandStack().func_190926_b() ? Hand.OFF_HAND : Hand.MAIN_HAND;
        return CompatActionResult.create(state.func_227031_a_(world, player.getEntity(), hand, hitResult));
    }

    public static CompatActionResult onUse(net.minecraft.block.BlockState state, World world, Player player, Direction dir, BlockPos blockPos) {
        return BlockStateUtil.onUse(state, world, player, BlockHitResultUtil.create(player.getPos(), dir, blockPos));
    }

    public static CompatActionResult onUseWithItem(net.minecraft.block.BlockState state, ItemStack stack, World world, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return CompatActionResult.create(state.func_227031_a_(world, player, hand, hit));
    }

    public static CompatActionResult onUseWithItem_actionResult(net.minecraft.block.BlockState state, ItemStack stack, World world, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return BlockStateUtil.onUseWithItem(state, stack, world, player, hand, hit);
    }

    public static FluidState getFluidState(net.minecraft.block.BlockState state) {
        return state.func_204520_s();
    }

    public static Fluid getFluid(net.minecraft.block.BlockState state) {
        return BlockStateUtil.getFluidState(state).func_206886_c();
    }

    public static net.minecraft.block.BlockState rotate(net.minecraft.block.BlockState state, Rotation rotation) {
        return state.func_185907_a(rotation);
    }

    public static BlockState getMidohraDefaultState(Block block) {
        return BlockState.of(BlockStateUtil.getDefaultState(block));
    }

    public static BlockState getDefaultState(BlockWrapper block) {
        return block.getDefaultState();
    }

    public static float getHardness(net.minecraft.block.BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_185887_b(world, pos);
    }

    public static float getHardness(net.minecraft.block.BlockState state, World world, BlockPos pos) {
        return state.func_185887_b((IBlockReader)world, pos);
    }

    public static int getLuminance(net.minecraft.block.BlockState state) {
        return state.func_185906_d();
    }

    public static int getOpacity(net.minecraft.block.BlockState state) {
        return state.func_200016_a(null, null);
    }

    public static int getComparatorOutput(net.minecraft.block.BlockState state, World world, BlockPos pos) {
        return state.func_185888_a(world, pos);
    }

    public static float getHardness(BlockState state, BlockView world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return BlockStateUtil.getHardness(state.toMinecraft(), world.getRaw(), pos.toMinecraft());
    }

    public static int getLuminance(BlockState state) {
        return BlockStateUtil.getLuminance(state.toMinecraft());
    }

    public static int getOpacity(BlockState state) {
        return BlockStateUtil.getOpacity(state.toMinecraft());
    }

    public static int getComparatorOutput(BlockState state, net.pitan76.mcpitanlib.midohra.world.World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return BlockStateUtil.getComparatorOutput(state.toMinecraft(), world.getRaw(), pos.toMinecraft());
    }
}

