/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class CustomDataUtil {
    public static CompoundNBT getOrCreateNbt(ItemStack stack) {
        if (!CustomDataUtil.hasNbt(stack)) {
            return NbtUtil.create();
        }
        return CustomDataUtil.getNbt(stack);
    }

    public static void setNbt(ItemStack stack, CompoundNBT nbt) {
        CompoundNBT components = NbtUtil.create();
        if (CustomDataUtil.hasNbt(stack)) {
            components = stack.func_77978_p().func_74775_l("components");
        }
        components.func_218657_a("minecraft:custom_data", (INBT)nbt);
        stack.func_196082_o().func_218657_a("components", (INBT)components);
    }

    public static boolean hasNbt(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b("components") && stack.func_77978_p().func_74775_l("components").func_74764_b("minecraft:custom_data");
    }

    public static CompoundNBT getNbt(ItemStack stack) {
        CompoundNBT components;
        CompoundNBT customData = NbtUtil.create();
        if (!CustomDataUtil.hasNbt(stack)) {
            return customData;
        }
        if (stack.func_77978_p().func_74764_b("components") && (components = stack.func_77978_p().func_74775_l("components")).func_74764_b("minecraft:custom_data")) {
            customData = components.func_74775_l("minecraft:custom_data").func_74737_b();
        }
        return customData;
    }

    public static void put(ItemStack stack, String key, CompoundNBT value) {
        CompoundNBT nbt = CustomDataUtil.getOrCreateNbt(stack);
        NbtUtil.put(nbt, key, value);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static CompoundNBT get(ItemStack stack, String key) {
        CompoundNBT nbt = CustomDataUtil.getNbt(stack);
        return nbt.func_74775_l(key);
    }

    public static void remove(ItemStack stack, String key) {
        CompoundNBT nbt = CustomDataUtil.getNbt(stack);
        nbt.func_82580_o(key);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static boolean has(ItemStack stack, String key) {
        if (!CustomDataUtil.hasNbt(stack)) {
            return false;
        }
        CompoundNBT nbt = CustomDataUtil.getNbt(stack);
        return nbt.func_74764_b(key);
    }

    public static <T> T get(ItemStack stack, String key, Class<T> clazz) {
        CompoundNBT nbt = CustomDataUtil.getNbt(stack);
        return NbtUtil.get(nbt, key, clazz);
    }

    public static <T> void set(ItemStack stack, String key, T value) {
        CompoundNBT nbt = CustomDataUtil.getOrCreateNbt(stack);
        NbtUtil.set(nbt, key, value);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static Set<String> getKeys(ItemStack stack) {
        CompoundNBT nbt = CustomDataUtil.getNbt(stack);
        return NbtUtil.getKeys(nbt);
    }

    public static <T> void put(ItemStack stack, String key, T value) {
        CustomDataUtil.set(stack, key, value);
    }

    public static boolean contains(ItemStack stack, String key) {
        return CustomDataUtil.has(stack, key);
    }

    public static void fix_oldNbt(ItemStack stack, String[] keys) {
        CompoundNBT customData = CustomDataUtil.getOrCreateNbt(stack);
        for (String key : keys) {
            if (!stack.func_77978_p().func_74764_b(key)) continue;
            customData.func_218657_a(key, stack.func_77978_p().func_74781_a(key));
            stack.func_77978_p().func_82580_o(key);
        }
        CustomDataUtil.setNbt(stack, customData);
    }

    public static void remove(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("components")) {
            CompoundNBT components = nbt.func_74775_l("components");
            components.func_82580_o("minecraft:custom_data");
            nbt.func_218657_a("components", (INBT)components);
        }
    }
}

