/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.state.property.CompatProperties;
import net.pitan76.mcpitanlib.api.state.property.DirectionProperty;

public class PropertyUtil {
    public static BooleanProperty createBooleanProperty(String name) {
        return BooleanProperty.func_177716_a((String)name);
    }

    public static DirectionProperty createDirectionProperty(String name) {
        return DirectionProperty.of(name);
    }

    public static IntegerProperty createIntProperty(String name, int min, int max) {
        return IntegerProperty.func_177719_a((String)name, (int)min, (int)max);
    }

    public static <T extends Enum<T>> EnumProperty<T> createEnumProperty(String name, Class<T> type) {
        return EnumProperty.func_177709_a((String)name, type);
    }

    public static BlockState with(BlockState state, BooleanProperty property, boolean value) {
        return (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(value));
    }

    public static BlockState with(BlockState state, IntegerProperty property, int value) {
        return (BlockState)state.func_206870_a((Property)property, (Comparable)Integer.valueOf(value));
    }

    public static BlockState with(BlockState state, DirectionProperty property, Direction value) {
        return property.with(state, value);
    }

    public static boolean get(BlockState state, BooleanProperty property) {
        return (Boolean)state.func_177229_b((Property)property);
    }

    public static int get(BlockState state, IntegerProperty property) {
        return (Integer)state.func_177229_b((Property)property);
    }

    public static Direction get(BlockState state, DirectionProperty property) {
        return (Direction)property.get(state);
    }

    public static net.pitan76.mcpitanlib.midohra.util.math.Direction getAsMidohra(BlockState state, DirectionProperty property) {
        return net.pitan76.mcpitanlib.midohra.util.math.Direction.of((Direction)property.get(state));
    }

    public static Direction getFacing(BlockState state) {
        return (Direction)PropertyUtil.facing().get(state);
    }

    public static Direction getHorizontalFacing(BlockState state) {
        return (Direction)PropertyUtil.horizontalFacing().get(state);
    }

    public static int getPower(BlockState state) {
        return (Integer)state.func_177229_b((Property)PropertyUtil.power());
    }

    public static boolean isPowered(BlockState state) {
        return (Boolean)state.func_177229_b((Property)PropertyUtil.powered());
    }

    public static void append(AppendPropertiesArgs args, Property<?> ... properties) {
        args.addProperty(properties);
    }

    public static void appendFacing(AppendPropertiesArgs args) {
        PropertyUtil.facing().apply(args);
    }

    public static void appendHorizontalFacing(AppendPropertiesArgs args) {
        PropertyUtil.horizontalFacing().apply(args);
    }

    public static void appendPower(AppendPropertiesArgs args) {
        args.addProperty(new Property[]{PropertyUtil.power()});
    }

    public static void appendPowered(AppendPropertiesArgs args) {
        args.addProperty(new Property[]{PropertyUtil.powered()});
    }

    public static IntegerProperty power() {
        return BlockStateProperties.field_208136_ak;
    }

    public static BooleanProperty powered() {
        return BlockStateProperties.field_208194_u;
    }

    public static DirectionProperty facing() {
        return CompatProperties.FACING;
    }

    public static DirectionProperty horizontalFacing() {
        return CompatProperties.HORIZONTAL_FACING;
    }

    public static EnumProperty<Direction.Axis> axis() {
        return BlockStateProperties.field_208148_A;
    }

    public static EnumProperty<Half> blockHalf() {
        return BlockStateProperties.field_208164_Q;
    }

    public static EnumProperty<StairsShape> stairShape() {
        return BlockStateProperties.field_208146_au;
    }

    public static BooleanProperty lit() {
        return BlockStateProperties.field_208190_q;
    }

    public static BooleanProperty waterlogged() {
        return BlockStateProperties.field_208198_y;
    }

    public static BooleanProperty attached() {
        return BlockStateProperties.field_208174_a;
    }

    public static BooleanProperty hanging() {
        return BlockStateProperties.field_222514_j;
    }

    public static BooleanProperty bottom() {
        return BlockStateProperties.field_222513_b;
    }

    public static BooleanProperty conditional() {
        return BlockStateProperties.field_208176_c;
    }

    public static BooleanProperty inWall() {
        return BlockStateProperties.field_208189_p;
    }

    public static BooleanProperty open() {
        return BlockStateProperties.field_208193_t;
    }

    public static BooleanProperty occupied() {
        return BlockStateProperties.field_208192_s;
    }

    public static boolean contains(BlockState state, Property<?> property) {
        return state.func_235901_b_(property);
    }
}

