/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.recipe.CompatRecipeType;
import net.pitan76.mcpitanlib.api.recipe.MatchGetter;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeEntry;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeNonEntry;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.IngredientUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;

public class RecipeUtil {
    public static ShapelessRecipe createShapelessRecipe(ResourceLocation id, String group, CompatibilityCraftingRecipeCategory category, ItemStack output, NonNullList<Ingredient> input) {
        return RecipeUtil.createShapelessRecipe(id, group, output, input);
    }

    public static ShapelessRecipe createShapelessRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> input) {
        return new ShapelessRecipe(id, group, output, input);
    }

    public static <C extends IInventory> ItemStack craft_2(IRecipe<C> recipe, C inventory, World world) {
        return recipe.func_77572_b(inventory);
    }

    public static <C extends IInventory> ItemStack getOutput_2(IRecipe<C> recipe, World world) {
        return recipe.func_77571_b();
    }

    public static ItemStack craft(IRecipe<?> recipe, IInventory inventory, World world) {
        if (inventory instanceof CraftingInventory) {
            IRecipe<?> inputRecipe = recipe;
            return inputRecipe.func_77572_b((IInventory)((CraftingInventory)inventory));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getOutput(IRecipe<?> recipe, World world) {
        return RecipeUtil.getOutput(recipe, RegistryLookupUtil.getRegistryLookup(world));
    }

    public static List<IRecipe<?>> getAllRecipes(World world) {
        Collection recipes = world.func_199532_z().func_199510_b();
        return new ArrayList(recipes);
    }

    public static List<CompatRecipeNonEntry<?>> getAllCompatRecipeEntry(World world) {
        List<IRecipe<?>> recipes = RecipeUtil.getAllRecipes(world);
        ArrayList outRecipes = new ArrayList();
        for (IRecipe<?> recipe : recipes) {
            outRecipes.add(new CompatRecipeNonEntry(recipe));
        }
        return outRecipes;
    }

    public static IRecipeType<?> getType(IRecipe<?> recipe) {
        return recipe.func_222127_g();
    }

    public static ResourceLocation getId(IRecipe<?> recipe) {
        return IdentifierUtil.id(recipe.getClass().hashCode() + "");
    }

    public static <I extends IInventory, T extends IRecipe<I>> CompatRecipeEntry<I> getFirstMatch(RecipeManager recipeManager, CompatRecipeType<T> type, CompatRecipeInput<I> input, World world) {
        Optional recipe = recipeManager.func_215371_a(type.getType(), input.getInput(), world);
        return recipe.map(CompatRecipeEntry::new).orElseGet(() -> new CompatRecipeEntry(null));
    }

    public static <I extends IInventory, T extends IRecipe<I>> CompatRecipeEntry<I> getFirstMatch(RecipeManager recipeManager, CompatRecipeType<T> type, CompatRecipeInput<I> input, World world, CompatIdentifier identifier) {
        return RecipeUtil.getFirstMatch(recipeManager, type, input, world);
    }

    public static <I extends IInventory, T extends IRecipe<I>> CompatRecipeEntry<I> getFirstMatch(World world, CompatRecipeType<T> type, CompatRecipeInput<I> input) {
        return RecipeUtil.getFirstMatch(RecipeUtil.getRecipeManager(world), type, input, world);
    }

    public static <I extends IInventory, T extends IRecipe<I>> CompatRecipeEntry<I> getFirstMatch(World world, CompatRecipeType<T> type, CompatRecipeInput<I> input, CompatIdentifier identifier) {
        return RecipeUtil.getFirstMatch(RecipeUtil.getRecipeManager(world), type, input, world, identifier);
    }

    public static RecipeManager getRecipeManager(World world) {
        return world.func_199532_z();
    }

    public Optional<IRecipe<?>> get(World world, CompatIdentifier id) {
        return this.get(RecipeUtil.getRecipeManager(world), id);
    }

    public Optional<IRecipe<?>> get(RecipeManager recipeManager, CompatIdentifier id) {
        return recipeManager.func_215367_a(id.toMinecraft());
    }

    public static <I extends IInventory, T extends IRecipe<I>> MatchGetter<I, T> createCachedMatchGetter(IRecipeType<T> type) {
        return (input, world) -> {
            Optional optional = RecipeUtil.getRecipeManager(world).func_215371_a(type, input.getInput(), world);
            return Optional.of(optional.map(CompatRecipeEntry::new).orElseGet(() -> new CompatRecipeEntry(null)));
        };
    }

    public static <I extends IInventory, T extends IRecipe<I>> MatchGetter<I, T> createCachedMatchGetter(CompatRecipeType<T> type) {
        return RecipeUtil.createCachedMatchGetter(type.getType());
    }

    public static NonNullList<Ingredient> getInputs(IRecipe<?> recipe) {
        return recipe.func_192400_c();
    }

    public static NonNullList<Ingredient> getInputs(CompatRecipeEntry<?> recipeEntry) {
        return RecipeUtil.getInputs(recipeEntry.getRecipe());
    }

    public static ItemStackList getInputsAsStack(IRecipe<?> recipe) {
        NonNullList<Ingredient> ingredients = RecipeUtil.getInputs(recipe);
        ItemStackList stacks = ItemStackList.ofSize(ingredients.size(), ItemStackUtil.empty());
        for (Ingredient ingredient : ingredients) {
            stacks.addAll(IngredientUtil.getMatchingStacksAsList(ingredient));
        }
        return stacks;
    }

    public static ItemStackList getInputsAsStack(CompatRecipeEntry<?> recipeEntry) {
        return RecipeUtil.getInputsAsStack(recipeEntry.getRecipe());
    }

    public static ItemStack getOutput(IRecipe<?> recipe, CompatRegistryLookup registryLookup) {
        return recipe.func_77571_b();
    }

    public static ItemStack getOutput(CompatRecipeEntry<?> recipeEntry, CompatRegistryLookup registryLookup) {
        return RecipeUtil.getOutput(recipeEntry.getRecipe(), registryLookup);
    }

    public static CompatRecipeType<?> getType(CompatRecipeEntry<?> recipeEntry) {
        return CompatRecipeType.of(recipeEntry.getRecipe().func_222127_g());
    }

    public static <I extends IInventory, T extends IRecipe<I>> ItemStackList getRemainder(CompatRecipeEntry<I> recipeEntry, CompatRecipeInput<I> input) {
        return ItemStackList.of((NonNullList<ItemStack>)recipeEntry.getRecipe().func_179532_b(input.getInput()));
    }

    public static enum CompatibilityCraftingRecipeCategory {
        BUILDING,
        REDSTONE,
        EQUIPMENT,
        MISC;

    }
}

