/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.pitan76.mcpitanlib.api.text.TextConverter;
import net.pitan76.mcpitanlib.api.util.StyleUtil;

public class TextUtil {
    public static IFormattableTextComponent literal(String string) {
        return new StringTextComponent(string);
    }

    public static IFormattableTextComponent translatable(String key) {
        return new TranslationTextComponent(key);
    }

    public static IFormattableTextComponent translatable(String key, Object ... args) {
        return new TranslationTextComponent(key, args);
    }

    public static IFormattableTextComponent empty() {
        return TextUtil.literal("");
    }

    public static IFormattableTextComponent keybind(String string) {
        return new KeybindTextComponent(string);
    }

    public static String txt2str(ITextComponent text) {
        return text.getString();
    }

    public static IFormattableTextComponent setStyle(IFormattableTextComponent text, Style style) {
        return text.func_230530_a_(style);
    }

    public static Style getStyle(IFormattableTextComponent text) {
        return text.func_150256_b();
    }

    public static IFormattableTextComponent withColor(IFormattableTextComponent text, int color) {
        return TextUtil.setStyle(text, StyleUtil.withColor(text.func_150256_b(), color));
    }

    public static IFormattableTextComponent withBold(IFormattableTextComponent text, boolean bold) {
        return TextUtil.setStyle(text, StyleUtil.withBold(text.func_150256_b(), bold));
    }

    public static IFormattableTextComponent append(IFormattableTextComponent text, ITextComponent sibling) {
        return text.func_230529_a_(sibling);
    }

    public static IFormattableTextComponent append(IFormattableTextComponent text, String string) {
        return text.func_240702_b_(string);
    }

    public static IFormattableTextComponent of(String string) {
        return TextUtil.literal(string);
    }

    public static IFormattableTextComponent convert(String text) {
        return TextConverter.convert(text, false);
    }

    public static IFormattableTextComponent convertWithTranslatable(String text) {
        return TextConverter.convert(text, true);
    }
}

