/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.math.random.CompatRandom;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.entity.EntityTypeWrapper;
import net.pitan76.mcpitanlib.midohra.world.chunk.ChunkTicketType;
import org.jetbrains.annotations.Nullable;

public class WorldUtil {
    public static boolean hasSkyLight(World world) {
        return world.func_230315_m_().func_218272_d();
    }

    public static boolean isThundering(World world) {
        return world.func_72911_I();
    }

    public static boolean isRaining(World world) {
        return world.func_72896_J();
    }

    public static boolean isNight(World world) {
        return world.func_226690_K_();
    }

    public static boolean isDay(World world) {
        return world.func_72935_r();
    }

    public static boolean isSkyVisible(World world, BlockPos pos) {
        return world.func_226660_f_(pos);
    }

    public static boolean isClient(World world) {
        return world.func_201670_d();
    }

    public static void scheduleBlockTick(World world, BlockPos pos, Block block, int delay) {
        world.func_205220_G_().func_205360_a(pos, (Object)block, delay);
    }

    public static void scheduleFluidTick(World world, BlockPos pos, Fluid fluid, int delay) {
        world.func_205219_F_().func_205360_a(pos, (Object)fluid, delay);
    }

    public static boolean isServer(World world) {
        return !WorldUtil.isClient(world);
    }

    public static void spawnStack(World world, BlockPos pos, ItemStack stack) {
        WorldUtil.spawnEntity(world, (Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
    }

    public static void spawnExperienceOrb(World world, Vector3d pos, int amount) {
        if (world instanceof ServerWorld) {
            WorldUtil.spawnEntity(world, (Entity)new ExperienceOrbEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), amount));
        }
    }

    public static void spawnExperienceOrb(World world, BlockPos pos, int amount) {
        WorldUtil.spawnExperienceOrb(world, Vector3d.func_237489_a_((Vector3i)pos), amount);
    }

    public static void spawnEntity(World world, Entity entity) {
        world.func_217376_c(entity);
    }

    public static void playSound(World world, @Nullable Player player, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        PlayerEntity entity = player == null ? null : player.getEntity();
        world.func_184133_a(entity, pos, sound, category, volume, pitch);
    }

    public static void playSound(World world, @Nullable Player player, BlockPos pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world, player, pos, sound.get(), category.get(), volume, pitch);
    }

    public static void playSound(World world, BlockPos pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world, null, pos, sound.get(), category.get(), volume, pitch);
    }

    public static void playSound(World world, double x, double y, double z, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch, boolean useDistance) {
        world.func_184134_a(x, y, z, sound.get(), category.get(), volume, pitch, useDistance);
    }

    public static void sendEntityStatus(World world, Entity entity, byte status) {
        world.func_72960_a(entity, status);
    }

    public static BlockPos getSpawnPos(World world) {
        return new BlockPos(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76075_d(), world.func_72912_H().func_76074_e());
    }

    public static Optional<MinecraftServer> getServer(World world) {
        if (WorldUtil.isClient(world)) {
            return Optional.empty();
        }
        return Optional.ofNullable(world.func_73046_m());
    }

    public static ServerWorld getWorld(World world, ResourceLocation worldId) {
        Optional<MinecraftServer> server = WorldUtil.getServer(world);
        if (!server.isPresent()) {
            return null;
        }
        return WorldUtil.getWorld(server.get(), worldId);
    }

    public static Optional<ServerWorld> getWorld(World world, CompatIdentifier worldId) {
        return Optional.ofNullable(WorldUtil.getWorld(world, worldId.toMinecraft()));
    }

    public static ServerWorld getOverworld(MinecraftServer server) {
        return server.func_71218_a(World.field_234918_g_);
    }

    public static ServerWorld getNether(MinecraftServer server) {
        return server.func_71218_a(World.field_234919_h_);
    }

    public static ServerWorld getEnd(MinecraftServer server) {
        return server.func_71218_a(World.field_234920_i_);
    }

    public static ServerWorld getWorld(MinecraftServer server, ResourceLocation worldId) {
        return server.func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)worldId));
    }

    public static ServerWorld getWorld(MinecraftServer server, CompatIdentifier worldId) {
        return WorldUtil.getWorld(server, worldId.toMinecraft());
    }

    public static ResourceLocation getWorldId(World world) {
        return world.func_234923_W_().func_240901_a_();
    }

    public static CompatIdentifier getCompatWorldId(World world) {
        return CompatIdentifier.fromMinecraft(WorldUtil.getWorldId(world));
    }

    public static boolean equals(World world, World world2) {
        return Objects.equals(WorldUtil.getWorldId(world), WorldUtil.getWorldId(world2));
    }

    @Deprecated
    public static <T> void addTicket(ServerWorld world, TicketType<T> type, ChunkPos pos, int radius, T argument) {
        world.func_72863_F().func_217228_a(type, pos, radius, argument);
    }

    @Deprecated
    public static <T> void removeTicket(ServerWorld world, TicketType<T> type, ChunkPos pos, int radius, T argument) {
        world.func_72863_F().func_217222_b(type, pos, radius, argument);
    }

    public static <T> void addTicket(ServerWorld world, ChunkTicketType<T> type, ChunkPos pos, int radius, T argument) {
        WorldUtil.addTicket(world, type.getRaw(), pos, radius, argument);
    }

    public static <T> void removeTicket(ServerWorld world, ChunkTicketType<T> type, ChunkPos pos, int radius, T argument) {
        WorldUtil.removeTicket(world, type.getRaw(), pos, radius, argument);
    }

    public static void addTicket(ServerWorld world, ChunkTicketType<?> type, ChunkPos pos, int radius) {
        TicketType<?> rawType = type.getRaw();
        world.func_72863_F().func_217228_a(rawType, pos, radius, (Object)pos);
    }

    public static void removeTicket(ServerWorld world, ChunkTicketType<?> type, ChunkPos pos, int radius) {
        TicketType<?> rawType = type.getRaw();
        world.func_72863_F().func_217222_b(rawType, pos, radius, (Object)pos);
    }

    public static boolean isReceivingRedstonePower(World world, BlockPos pos) {
        return world.func_175640_z(pos);
    }

    public static int getBottomY(World world) {
        return 0;
    }

    public static int getTopY(World world) {
        return world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, 0, 0);
    }

    public static int getDimensionHeight(World world) {
        return world.func_230315_m_().func_241513_m_();
    }

    public static TileEntity getBlockEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public static boolean hasBlockEntity(World world, BlockPos pos) {
        return WorldUtil.getBlockEntity(world, pos) != null;
    }

    public static net.minecraft.block.BlockState getBlockState(World world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public static FluidState getFluidState(World world, BlockPos pos) {
        return world.func_204610_c(pos);
    }

    public static boolean hasFluidState(World world, BlockPos pos) {
        return !WorldUtil.getFluidState(world, pos).func_206888_e();
    }

    public static boolean isAir(World world, BlockPos pos) {
        return WorldUtil.getBlockState(world, pos).func_196958_f();
    }

    public static boolean setBlockState(World world, BlockPos pos, net.minecraft.block.BlockState state, int flags) {
        return world.func_180501_a(pos, state, flags);
    }

    public static boolean setBlockState(World world, BlockPos pos, net.minecraft.block.BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(World world, BlockPos pos, Block block, int flags) {
        return WorldUtil.setBlockState(world, pos, block.func_176223_P(), flags);
    }

    public static boolean setBlockState(World world, BlockPos pos, Block block) {
        return WorldUtil.setBlockState(world, pos, block, 3);
    }

    public static boolean breakBlock(World world, BlockPos pos, boolean drop) {
        return world.func_175655_b(pos, drop);
    }

    public static boolean breakBlock(World world, BlockPos pos) {
        return WorldUtil.breakBlock(world, pos, true);
    }

    public static boolean breakBlock(World world, BlockPos pos, boolean drop, @Nullable Player player) {
        if (player == null) {
            return world.func_225521_a_(pos, drop, null);
        }
        return world.func_225521_a_(pos, drop, (Entity)player.getPlayerEntity());
    }

    public static boolean breakBlock(World world, BlockPos pos, @Nullable Player player) {
        return WorldUtil.breakBlock(world, pos, true, player);
    }

    public static void removeBlockEntity(World world, BlockPos pos) {
        world.func_175713_t(pos);
    }

    public static boolean removeBlock(World world, BlockPos pos, boolean move) {
        return world.func_217377_a(pos, move);
    }

    public static void addParticle(World world, IParticleData parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        world.func_195594_a(parameters, x, y, z, velocityX, velocityY, velocityZ);
    }

    public static boolean canSetBlock(World world, BlockPos pos) {
        return world.func_195588_v(pos);
    }

    public static void updateComparators(World world, BlockPos pos, Block block) {
        world.func_175666_e(pos, block);
    }

    public static List<Player> getPlayers(World world) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (PlayerEntity player : world.func_217369_A()) {
            players.add(new Player(player));
        }
        return players;
    }

    public static Player getPlayer(World world, UUID uuid) {
        return new Player(world.func_217371_b(uuid));
    }

    public static CompatRandom getRandom(World world) {
        return new CompatRandom(world.func_201674_k());
    }

    public static long getTime(World world) {
        return world.func_82737_E();
    }

    public static <T extends Entity> List<T> getEntitiesByType(World world, EntityType<T> filter, AxisAlignedBB box, Predicate<? super T> predicate) {
        return world.func_217394_a(filter, box, predicate);
    }

    public static <T extends Entity> List<T> getEntitiesByClass(World world, Class<T> entityClass, AxisAlignedBB box, Predicate<? super T> predicate) {
        return world.func_175647_a(entityClass, box, predicate);
    }

    public static void spawnParticles(World world, IParticleData parameters, double x, double y, double z, int count, double velocityX, double velocityY, double velocityZ, double speed) {
        if (!WorldUtil.isServer(world)) {
            return;
        }
        ((ServerWorld)world).func_195598_a(parameters, x, y, z, count, velocityX, velocityY, velocityZ, speed);
    }

    public static void updateListeners(World world, BlockPos pos, net.minecraft.block.BlockState oldState, net.minecraft.block.BlockState newState, int flags) {
        world.func_184138_a(pos, oldState, newState, flags);
    }

    public static BlockState getMidohraBlockState(World world, BlockPos pos) {
        return BlockState.of(WorldUtil.getBlockState(world, pos));
    }

    public static boolean setBlockState(World world, BlockPos pos, BlockState state, int flags) {
        return WorldUtil.setBlockState(world, pos, state.toMinecraft(), flags);
    }

    public static boolean setBlockState(World world, BlockPos pos, BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockState state, int flags) {
        return WorldUtil.setBlockState(world, pos.toMinecraft(), state.toMinecraft(), flags);
    }

    public static boolean setBlockState(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean breakBlock(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean drop) {
        return WorldUtil.breakBlock(world, pos.toMinecraft(), drop);
    }

    public static boolean breakBlock(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return WorldUtil.breakBlock(world, pos, true);
    }

    public static boolean breakBlock(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean drop, @Nullable Player player) {
        return WorldUtil.breakBlock(world, pos.toMinecraft(), drop, player);
    }

    public static boolean breakBlock(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, @Nullable Player player) {
        return WorldUtil.breakBlock(world, pos, true, player);
    }

    public static void removeBlockEntity(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        WorldUtil.removeBlockEntity(world, pos.toMinecraft());
    }

    public static boolean removeBlock(World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean move) {
        return WorldUtil.removeBlock(world, pos.toMinecraft(), move);
    }

    public static void playSound(net.pitan76.mcpitanlib.midohra.world.World world, @Nullable Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world.getRaw(), player, pos.toMinecraft(), sound, category, volume, pitch);
    }

    public static void dropStackOnBlock(World world, BlockPos pos, ItemStack stack) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
    }

    public static float getSkyAngle(World world, float tickDelta) {
        return world.func_242415_f(tickDelta);
    }

    public static Block getBlock(World world, BlockPos pos) {
        return WorldUtil.getBlockState(world, pos).func_177230_c();
    }

    public static BlockWrapper getBlockWrapper(World world, BlockPos pos) {
        return BlockWrapper.of(WorldUtil.getBlock(world, pos));
    }

    public static <T extends Entity> List<T> getEntitiesByType(World world, EntityType<T> filter, AxisAlignedBB box) {
        return WorldUtil.getEntitiesByType(world, filter, box, EntityPredicates.field_94557_a);
    }

    public static <T extends Entity> List<T> getEntitiesByType(World world, EntityTypeWrapper filter, AxisAlignedBB box, Predicate<? super T> predicate) {
        return WorldUtil.getEntitiesByType(world, filter.get(), box, predicate);
    }

    public static List<?> getEntitiesByType(World world, EntityTypeWrapper filter, AxisAlignedBB box) {
        return WorldUtil.getEntitiesByType(world, filter.get(), box);
    }

    public static CompatIdentifier getOverworldId() {
        return CompatIdentifier.fromMinecraft(World.field_234918_g_.func_240901_a_());
    }

    public static CompatIdentifier getNetherId() {
        return CompatIdentifier.fromMinecraft(World.field_234919_h_.func_240901_a_());
    }

    public static CompatIdentifier getEndId() {
        return CompatIdentifier.fromMinecraft(World.field_234920_i_.func_240901_a_());
    }
}

