/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.pitan76.mcpitanlib.api.block.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.v2.BlockUtilV2;

public class BlockUtil {
    public static boolean isEqual(Block block, Block block2) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.isEqual(block, block2);
    }

    public static Block fromId(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.fromId(id);
    }

    public static Block fromId(String id) {
        return BlockUtil.fromId(CompatIdentifier.of(id));
    }

    public static Block fromId(String namespace, String path) {
        return BlockUtil.fromId(CompatIdentifier.of(namespace, path));
    }

    public static CompatIdentifier toId(Block block) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.toCompatID(block);
    }

    public static String toIdAsString(Block block) {
        return BlockUtil.toId(block).toString();
    }

    public static boolean isExist(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.isExist(id);
    }

    public static boolean isExist(String id) {
        return BlockUtil.isExist(CompatIdentifier.of(id));
    }

    public static boolean isExist(String namespace, String path) {
        return BlockUtil.isExist(CompatIdentifier.of(namespace, path));
    }

    public static boolean isMinecraftBlock(Block block) {
        return CompatIdentifier.isMinecraftNamespace(BlockUtil.toId(block));
    }

    public static Block create(CompatibleBlockSettings settings) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.of(settings);
    }

    public static List<Block> getBlocks() {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.getAllBlocks();
    }

    public static List<Block> getInTag(TagKey<Block> tagKey) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.getBlocks(tagKey);
    }

    public static List<Block> getInTag(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.getBlocks(id.toMinecraft());
    }

    public static List<Block> getInTag(String id) {
        return BlockUtil.getInTag(CompatIdentifier.of(id));
    }

    public static List<Block> getInTag(String namespace, String path) {
        return BlockUtil.getInTag(CompatIdentifier.of(namespace, path));
    }

    public static boolean isInTag(Block block, TagKey<Block> tagKey) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.isIn(block, tagKey);
    }

    public static boolean isInTag(Block block, CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.isBlockInTag(block, id.toMinecraft());
    }

    public static boolean isInTag(Block block, String id) {
        return BlockUtil.isInTag(block, CompatIdentifier.of(id));
    }

    public static boolean isInTag(Block block, String namespace, String path) {
        return BlockUtil.isInTag(block, CompatIdentifier.of(namespace, path));
    }

    public static int getRawId(Block block) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.getRawId(block);
    }

    public static Block fromRawId(int rawId) {
        return net.pitan76.mcpitanlib.api.util.BlockUtil.fromIndex(rawId);
    }

    public static List<Block> getBlocksInNamespace(String namespace) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block block : BlockUtil.getBlocks()) {
            if (!BlockUtil.toId(block).getNamespace().equals(namespace)) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public static int getNumberOfBlocks() {
        return BlockUtil.getBlocks().size();
    }

    public static Item toItem(Block block) {
        return block.func_199767_j();
    }

    public static String getNameAsString(Block block) {
        return block.func_235333_g_().getString();
    }

    public static TextComponent getName(Block block) {
        return new TextComponent((ITextComponent)block.func_235333_g_());
    }

    public static String getTranslationKey(Block block) {
        return block.func_149739_a();
    }

    public static Block fromItem(Item item) {
        return BlockUtilV2.fromItem(item);
    }

    public static Block fromItem(ItemStack stack) {
        return BlockUtilV2.fromItem(stack);
    }
}

