/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class ItemEntityUtil {
    public static ItemEntity create(World world, double x, double y, double z, ItemStack stack) {
        return new ItemEntity(world, x, y, z, stack);
    }

    public static ItemEntity create(World world, BlockPos pos, ItemStack stack) {
        return ItemEntityUtil.create(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
    }

    public static ItemEntity create(World world, Vector3d pos, ItemStack stack) {
        return ItemEntityUtil.create(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
    }

    public static ItemEntity create(World world, double x, double y, double z, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        ItemEntity itemEntity = ItemEntityUtil.create(world, x, y, z, stack);
        ItemEntityUtil.setVelocity(itemEntity, velocityX, velocityY, velocityZ);
        return itemEntity;
    }

    public static void setVelocity(ItemEntity itemEntity, double velocityX, double velocityY, double velocityZ) {
        itemEntity.func_213293_j(velocityX, velocityY, velocityZ);
    }

    public static void setVelocity(ItemEntity itemEntity, Vector3d vec3d) {
        itemEntity.func_213317_d(vec3d);
    }

    public static void setPickupDelay(ItemEntity itemEntity, int pickupDelay) {
        itemEntity.func_174867_a(pickupDelay);
    }

    public static void setToDefaultPickupDelay(ItemEntity itemEntity) {
        itemEntity.func_174869_p();
    }

    public static ItemStack getStack(ItemEntity entity) {
        return entity.func_92059_d();
    }

    public static List<ItemEntity> getEntities(World world, AxisAlignedBB box) {
        return WorldUtil.getEntitiesByType(world, EntityType.field_200765_E, box);
    }

    public static ItemEntity createWithSpawn(World world, ItemStack stack, double x, double y, double z) {
        ItemEntity itemEntity = ItemEntityUtil.create(world, x, y, z, stack);
        ItemEntityUtil.setToDefaultPickupDelay(itemEntity);
        ItemEntityUtil.setVelocity(itemEntity, 0.0, 0.0, 0.0);
        WorldUtil.spawnEntity(world, (Entity)itemEntity);
        return itemEntity;
    }

    public static ItemEntity createWithSpawn(World world, ItemStack stack, BlockPos pos) {
        return ItemEntityUtil.createWithSpawn(world, stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

