/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.recipe.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;

public class CraftingRecipeInputUtil {
    public static Optional<CraftingInventory> get(CompatRecipeInput<?> input) {
        if (input.getInput() instanceof CraftingInventory) {
            return Optional.of((CraftingInventory)input.getInput());
        }
        return Optional.empty();
    }

    public static CompatRecipeInput<?> create(CraftingInventory input) {
        return new CompatRecipeInput<CraftingInventory>(input);
    }

    public static CompatRecipeInput<?> create(int width, int height, List<net.minecraft.item.ItemStack> stacks) {
        CraftingInventory inventory = new CraftingInventory(null, width, height);
        int size = stacks.size();
        for (int i = 0; i < size; ++i) {
            inventory.func_70299_a(i, stacks.get(i));
        }
        return new CompatRecipeInput<CraftingInventory>(inventory);
    }

    public static net.minecraft.item.ItemStack getStack(CraftingInventory input, int x, int y) {
        return input.func_70301_a(x + y * input.func_174922_i());
    }

    public static net.minecraft.item.ItemStack getStack(CompatRecipeInput<?> input, int x, int y) {
        Optional<CraftingInventory> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return ItemStackUtil.empty();
        }
        return CraftingRecipeInputUtil.getStack(recipeInput.get(), x, y);
    }

    public static ItemStack getMidohraStack(CompatRecipeInput<?> input, int x, int y) {
        return ItemStack.of(CraftingRecipeInputUtil.getStack(input, x, y));
    }

    public static RecipeItemHelper getRecipeMatcher(CraftingInventory input) {
        return null;
    }

    public static RecipeItemHelper getRecipeMatcher(CompatRecipeInput<?> input) {
        Optional<CraftingInventory> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getRecipeMatcher(recipeInput.get());
    }

    public static List<net.minecraft.item.ItemStack> getStacks(CraftingInventory input) {
        ArrayList<net.minecraft.item.ItemStack> stacks = new ArrayList<net.minecraft.item.ItemStack>();
        int size = input.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            stacks.add(input.func_70301_a(i));
        }
        return stacks;
    }

    public static List<net.minecraft.item.ItemStack> getStacks(CompatRecipeInput<?> input) {
        Optional<CraftingInventory> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getStacks(recipeInput.get());
    }

    public static int getWidth(CraftingInventory input) {
        return input.func_174922_i();
    }

    public static int getWidth(CompatRecipeInput<?> input) {
        Optional<CraftingInventory> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getWidth(recipeInput.get());
    }

    public static int getHeight(CraftingInventory input) {
        return input.func_174923_h();
    }

    public static int getHeight(CompatRecipeInput<?> input) {
        Optional<CraftingInventory> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getHeight(recipeInput.get());
    }

    public static int getStackCount(CraftingInventory input) {
        return input.func_70302_i_();
    }

    public static int getStackCount(CompatRecipeInput<?> input) {
        Optional<CraftingInventory> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getStackCount(recipeInput.get());
    }
}

