/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.nbt;

import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import net.pitan76.mcpitanlib.midohra.nbt.ElementConvertible;
import net.pitan76.mcpitanlib.midohra.nbt.NbtElement;

public class NbtCompound
implements ElementConvertible {
    protected final CompoundNBT nbt;

    protected NbtCompound(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public static NbtCompound of(CompoundNBT nbt) {
        return new NbtCompound(nbt);
    }

    public static NbtCompound of() {
        return new NbtCompound(NbtUtil.create());
    }

    public NbtCompound copy() {
        return new NbtCompound(NbtUtil.copy(this.nbt));
    }

    public boolean has(String key) {
        return NbtUtil.has(this.nbt, key);
    }

    public void putByte(String key, byte value) {
        NbtUtil.putByte(this.nbt, key, value);
    }

    public byte getByte(String key) {
        return NbtUtil.getByte(this.nbt, key);
    }

    public void putShort(String key, short value) {
        NbtUtil.putShort(this.nbt, key, value);
    }

    public short getShort(String key) {
        return NbtUtil.getShort(this.nbt, key);
    }

    public void putInt(String key, int value) {
        NbtUtil.putInt(this.nbt, key, value);
    }

    public int getInt(String key) {
        return NbtUtil.getInt(this.nbt, key);
    }

    public void putLong(String key, long value) {
        NbtUtil.putLong(this.nbt, key, value);
    }

    public long getLong(String key) {
        return NbtUtil.getLong(this.nbt, key);
    }

    public void putFloat(String key, float value) {
        NbtUtil.putFloat(this.nbt, key, value);
    }

    public float getFloat(String key) {
        return NbtUtil.getFloat(this.nbt, key);
    }

    public void putDouble(String key, double value) {
        NbtUtil.putDouble(this.nbt, key, value);
    }

    public double getDouble(String key) {
        return NbtUtil.getDouble(this.nbt, key);
    }

    public void putString(String key, String value) {
        NbtUtil.putString(this.nbt, key, value);
    }

    public String getString(String key) {
        return NbtUtil.getString(this.nbt, key);
    }

    public void putBoolean(String key, boolean value) {
        NbtUtil.putBoolean(this.nbt, key, value);
    }

    public boolean getBoolean(String key) {
        return NbtUtil.getBoolean(this.nbt, key);
    }

    public void putUuid(String key, UUID value) {
        NbtUtil.putUuid(this.nbt, key, value);
    }

    public UUID getUuid(String key) {
        return NbtUtil.getUuid(this.nbt, key);
    }

    public void putItemStack(String key, ItemStack stack, CompatRegistryLookup registryLookup) {
        NbtUtil.putItemStack(this.nbt, key, stack.toMinecraft(), registryLookup);
    }

    public ItemStack getItemStack(String key, CompatRegistryLookup registryLookup) {
        return ItemStack.of(NbtUtil.getItemStack(this.nbt, key, registryLookup).get());
    }

    public void put(String key, NbtCompound compound) {
        NbtUtil.put(this.nbt, key, compound.nbt);
    }

    public void put(String key, CompoundNBT nbt) {
        NbtUtil.put(this.nbt, key, nbt);
    }

    public void put(String key, ElementConvertible element) {
        NbtUtil.put(this.nbt, key, element.toMinecraftNbtElement());
    }

    public NbtCompound getCompound(String key) {
        return new NbtCompound(NbtUtil.get(this.nbt, key));
    }

    public NbtElement get(String key) {
        return NbtElement.of(NbtUtil.getElement(this.nbt, key));
    }

    public CompoundNBT toMinecraft() {
        return this.nbt;
    }

    public String toString() {
        return this.nbt.toString();
    }

    @Override
    public NbtElement toElement() {
        return NbtElement.of((INBT)this.nbt);
    }
}

