/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.resources.IResource;
import net.pitan76.mcpitanlib.api.util.LoggerUtil;
import net.pitan76.mcpitanlib.api.util.ResourceUtil;
import org.apache.commons.io.IOUtils;

public class Resource {
    private final IResource resource;

    protected Resource(IResource resource) {
        this.resource = resource;
    }

    public static Resource of(IResource resource) {
        return new Resource(resource);
    }

    public IResource getRaw() {
        return this.resource;
    }

    public IResource toMinecraft() {
        return this.getRaw();
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), StandardCharsets.UTF_8));
    }

    public String getPackId() {
        return this.resource.func_199026_d();
    }

    public InputStream getInputStream() {
        return ResourceUtil.getInputStream(this.resource);
    }

    public void close() {
        try {
            ResourceUtil.close(this.resource);
        }
        catch (IOException e) {
            LoggerUtil.error(LoggerUtil.getLogger(), "Failed to close resource: " + e.getMessage());
        }
    }

    public String getContent() throws IOException {
        String content = IOUtils.toString((InputStream)this.getInputStream(), (Charset)StandardCharsets.UTF_8);
        this.close();
        return content;
    }

    public String getContent(String encoding) throws IOException {
        String content = IOUtils.toString((InputStream)this.getInputStream(), (String)encoding);
        this.close();
        return content;
    }

    public String getContent(Charset encoding) throws IOException {
        String content = IOUtils.toString((InputStream)this.getInputStream(), (Charset)encoding);
        this.close();
        return content;
    }
}

