/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.LoggerUtil;
import net.pitan76.mcpitanlib.api.util.ResourceUtil;
import net.pitan76.mcpitanlib.midohra.resource.Resource;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.WorldAccess;

public class ResourceManager {
    private final IResourceManager resourceManager;

    protected ResourceManager(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static ResourceManager of(IResourceManager resourceManager) {
        return new ResourceManager(resourceManager);
    }

    public static ResourceManager of(MinecraftServer server) {
        return null;
    }

    public static ResourceManager of(MCServer server) {
        return ResourceManager.of(server.getRaw());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceManager of(Minecraft client) {
        return ResourceManager.of(client.func_195551_G());
    }

    public static ResourceManager of(IWorld worldAccess) {
        if (worldAccess instanceof World) {
            return ResourceManager.of(((World)worldAccess).func_73046_m());
        }
        return null;
    }

    public static ResourceManager of(WorldAccess worldAccess) {
        return ResourceManager.of(worldAccess.getServer());
    }

    public IResourceManager getRaw() {
        return this.resourceManager;
    }

    public IResourceManager toMinecraft() {
        return this.getRaw();
    }

    public Map<CompatIdentifier, Resource> findResources(String startPath, String endPath) {
        HashMap<CompatIdentifier, Resource> map = new HashMap<CompatIdentifier, Resource>();
        try {
            Map<ResourceLocation, IResource> rawMap = ResourceUtil.findResources(this.resourceManager, startPath, endPath);
            for (Map.Entry<ResourceLocation, IResource> entry : rawMap.entrySet()) {
                map.put(CompatIdentifier.fromMinecraft(entry.getKey()), Resource.of(entry.getValue()));
            }
        }
        catch (IOException e) {
            LoggerUtil.error(LoggerUtil.getLogger(), "Failed to read " + startPath + ": " + e.getMessage());
            return null;
        }
        return map;
    }

    public Resource getResource(CompatIdentifier id) {
        try {
            return Resource.of(this.resourceManager.func_199002_a(id.toMinecraft()));
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<Resource> getAllResources(CompatIdentifier id) {
        try {
            return this.resourceManager.func_199004_b(id.toMinecraft()).stream().map(Resource::of).collect(Collectors.toList());
        }
        catch (IOException e) {
            return null;
        }
    }
}

