/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.util.hit;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.pitan76.mcpitanlib.midohra.util.hit.BlockHitResult;
import net.pitan76.mcpitanlib.midohra.util.hit.HitResultType;

public class HitResult {
    protected final RayTraceResult raw;

    public HitResult(RayTraceResult raw) {
        this.raw = raw;
    }

    public static HitResult of(RayTraceResult raw) {
        return new HitResult(raw);
    }

    @Deprecated
    public RayTraceResult getRaw() {
        return this.raw;
    }

    @Deprecated
    public RayTraceResult.Type getRawType() {
        return this.getRaw().func_216346_c();
    }

    public Vector3d getPos() {
        return this.getRaw().func_216347_e();
    }

    public double getX() {
        return this.pos().field_72450_a;
    }

    public double getY() {
        return this.pos().field_72448_b;
    }

    public double getZ() {
        return this.pos().field_72449_c;
    }

    public HitResultType getType() {
        return HitResultType.of(this);
    }

    public double squaredDistanceTo(Vector3d point) {
        Vector3d hitPos = this.getPos();
        double dx = hitPos.field_72450_a - point.field_72450_a;
        double dy = hitPos.field_72448_b - point.field_72448_b;
        double dz = hitPos.field_72449_c - point.field_72449_c;
        return dx * dx + dy * dy + dz * dz;
    }

    public double squaredDistanceTo(Entity entity) {
        return this.getRaw().func_237486_a_(entity);
    }

    public Vector3d pos() {
        return this.getPos();
    }

    public double x() {
        return this.getX();
    }

    public double y() {
        return this.getY();
    }

    public double z() {
        return this.getZ();
    }

    public Optional<BlockHitResult> asBlockHitResult() {
        if (this instanceof BlockHitResult) {
            return Optional.of((BlockHitResult)this);
        }
        if (this.raw instanceof BlockRayTraceResult) {
            return Optional.of(BlockHitResult.of((BlockRayTraceResult)this.raw));
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HitResult other = (HitResult)obj;
        return this.getRaw().equals(other.getRaw());
    }

    public int hashCode() {
        return this.getRaw().hashCode();
    }

    public String toString() {
        return this.getRaw().toString();
    }
}

