/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.recipe.RecipeManager;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.WorldAccess;

public class World
extends WorldAccess {
    private final net.minecraft.world.World world;

    protected World(net.minecraft.world.World world) {
        super((IWorld)null);
        this.world = world;
    }

    public static World of(net.minecraft.world.World world) {
        return new World(world);
    }

    public net.minecraft.world.World getRaw() {
        return this.world;
    }

    public net.minecraft.world.World toMinecraft() {
        return this.getRaw();
    }

    public void addBlockEntity(BlockEntityWrapper blockEntity) {
        this.addBlockEntity(blockEntity.get());
    }

    public void addBlockEntity(TileEntity blockEntity) {
        this.getRaw().func_175700_a(blockEntity);
    }

    public void removeBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        this.getRaw().func_175713_t(pos.toMinecraft());
    }

    public long getTime() {
        return WorldUtil.getTime(this.getRaw());
    }

    public long getTopY() {
        return WorldUtil.getTopY(this.getRaw());
    }

    public long getBottomY() {
        return WorldUtil.getBottomY(this.getRaw());
    }

    public long getDimensionHeight() {
        return WorldUtil.getDimensionHeight(this.getRaw());
    }

    public CompatIdentifier getId() {
        return WorldUtil.getCompatWorldId(this.getRaw());
    }

    public FluidState getRawFluidState(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return WorldUtil.getFluidState(this.getRaw(), pos.toMinecraft());
    }

    public Player getPlayerByUUID(UUID uuid) {
        return WorldUtil.getPlayer(this.getRaw(), uuid);
    }

    public List<Player> getPlayers() {
        return WorldUtil.getPlayers(this.getRaw());
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getSpawnPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(WorldUtil.getSpawnPos(this.getRaw()));
    }

    public Optional<World> getWorld(CompatIdentifier id) {
        Optional<net.minecraft.world.server.ServerWorld> optional = WorldUtil.getWorld(this.getRaw(), id);
        return optional.map(World::of);
    }

    public Optional<ServerWorld> getServerWorld(CompatIdentifier id) {
        Optional<net.minecraft.world.server.ServerWorld> optional = WorldUtil.getWorld(this.getRaw(), id);
        return optional.map(ServerWorld::of);
    }

    public void spawnEntity(Entity entity) {
        WorldUtil.spawnEntity(this.getRaw(), entity);
    }

    public void spawnStack(ItemStack stack, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        WorldUtil.spawnStack(this.getRaw(), pos.toMinecraft(), stack);
    }

    public RecipeManager getRecipeManager() {
        return RecipeManager.of(this.getRaw().func_199532_z());
    }

    @Override
    @Deprecated
    public void playSound(PlayerEntity playerEntity, BlockPos pos, SoundEvent sound, SoundCategory category) {
        this.getRaw().func_184133_a(playerEntity, pos, sound, category, 1.0f, 1.0f);
    }

    @Override
    @Deprecated
    public void playSound(PlayerEntity playerEntity, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        this.getRaw().func_184133_a(playerEntity, pos, sound, category, volume, pitch);
    }

    @Override
    public void playSound(Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(this.getRaw(), player, pos.toMinecraft(), soundEvent, category, volume, pitch);
    }

    @Override
    public void playSound(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(null, pos, soundEvent, category, 1.0f, 1.0f);
    }

    @Override
    public void playSound(Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(player, pos, soundEvent, category, 1.0f, 1.0f);
    }

    @Override
    public void playSound(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(null, pos, soundEvent, category, volume, pitch);
    }

    public Optional<ServerWorld> toServerWorld() {
        if (this.getRaw() instanceof net.minecraft.world.server.ServerWorld) {
            return Optional.of(ServerWorld.of((net.minecraft.world.server.ServerWorld)this.getRaw()));
        }
        return Optional.empty();
    }

    public CompatRegistryLookup getRegistryLookup() {
        return RegistryLookupUtil.getRegistryLookup(this.getRaw());
    }
}

