/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world.chunk;

import java.util.Comparator;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.TicketType;

public class ChunkTicketType<T> {
    public static final ChunkTicketType<Unit> START = ChunkTicketType.of(TicketType.field_219488_a);
    public static final ChunkTicketType<Unit> DRAGON = ChunkTicketType.of(TicketType.field_219489_b);
    public static final ChunkTicketType<ChunkPos> PLAYER = ChunkTicketType.of(TicketType.field_219490_c);
    public static final ChunkTicketType<ChunkPos> FORCED = ChunkTicketType.of(TicketType.field_219491_d);
    public static final ChunkTicketType<BlockPos> PORTAL = ChunkTicketType.of(TicketType.field_219493_f);
    public static final ChunkTicketType<ChunkPos> ENDER_PEARL = ChunkTicketType.of(TicketType.field_219494_g);
    public static final ChunkTicketType<Integer> POST_TELEPORT = ChunkTicketType.of(TicketType.field_223185_g);
    public static final ChunkTicketType<ChunkPos> UNKNOWN = ChunkTicketType.of(TicketType.field_219494_g);
    private final TicketType<T> ticketType;

    protected ChunkTicketType(TicketType<T> ticketType) {
        this.ticketType = ticketType;
    }

    public static <T> ChunkTicketType<T> of(TicketType<T> ticketType) {
        return new ChunkTicketType<T>(ticketType);
    }

    public TicketType<T> getRaw() {
        return this.ticketType;
    }

    public TicketType<T> toMinecraft() {
        return this.getRaw();
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator) {
        return ChunkTicketType.of(TicketType.func_219484_a((String)name, argumentComparator));
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator, int expiryTicks) {
        return ChunkTicketType.of(TicketType.func_223183_a((String)name, argumentComparator, (int)expiryTicks));
    }

    public Comparator<T> getArgumentComparator() {
        return this.getRaw().func_219487_a();
    }

    public long getExpiryTicks() {
        return this.getRaw().func_223184_b();
    }

    public String toString() {
        return this.getRaw().toString();
    }

    public ChunkTicketType(String name, long expiryTicks) {
        this(ChunkTicketType._of(name, expiryTicks));
    }

    public ChunkTicketType(String name) {
        this(name, 0L);
    }

    public static ChunkTicketType<ChunkPos> create(String name, long expiryTicks) {
        return new ChunkTicketType<ChunkPos>(name, expiryTicks);
    }

    public static ChunkTicketType<ChunkPos> create(String name) {
        return new ChunkTicketType<ChunkPos>(name);
    }

    private static <T> TicketType<T> _of(String name, long expiryTicks) {
        TicketType type = TicketType.func_223183_a((String)name, Comparator.comparingLong(ChunkPos::func_201841_a), (int)((int)expiryTicks));
        return type;
    }

    public int hashCode() {
        return this.ticketType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChunkTicketType)) {
            return false;
        }
        ChunkTicketType that = (ChunkTicketType)obj;
        return this.ticketType.equals(that.ticketType);
    }
}

