/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.v1;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.pitan76.mcpitanlib.api.block.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.tag.MineableToolTags;

public class BlockUtilV1 {
    public static Block block(ResourceLocation id) {
        return (Block)BuiltInRegistries.BLOCK.get(id);
    }

    public static BlockBehaviour.Properties breakByTool(BlockBehaviour.Properties settings, MineableToolTags toolTags, int level) {
        return settings;
    }

    public static BlockBehaviour.Properties dropsNothing(BlockBehaviour.Properties settings) {
        return settings.noLootTable();
    }

    public static BlockBehaviour.Properties requiresTool(BlockBehaviour.Properties settings) {
        return settings.requiresCorrectToolForDrops();
    }

    public static boolean isExist(ResourceLocation identifier) {
        return BuiltInRegistries.BLOCK.containsKey(identifier);
    }

    public static ResourceLocation toID(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static Block fromId(ResourceLocation identifier) {
        return (Block)BuiltInRegistries.BLOCK.get(identifier);
    }

    public static List<Block> getAllBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block block : BuiltInRegistries.BLOCK) {
            blocks.add(block);
        }
        return blocks;
    }

    @Deprecated
    public static Block of(BlockBehaviour.Properties settings) {
        return new Block(settings);
    }

    public static Block of(CompatibleBlockSettings settings) {
        return BlockUtilV1.of(settings.build());
    }

    public static int getRawId(Block block) {
        return BuiltInRegistries.BLOCK.getId((Object)block);
    }

    public static Block fromIndex(int index) {
        return (Block)BuiltInRegistries.BLOCK.byId(index);
    }
}

