/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.block;

import net.minecraft.world.level.block.Block;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.block.BlockUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import org.jetbrains.annotations.Nullable;

public class BlockWrapper {
    private final Block block;

    protected BlockWrapper() {
        this.block = null;
    }

    protected BlockWrapper(Block block) {
        this.block = block;
    }

    public static BlockWrapper of(Block block) {
        return new BlockWrapper(block);
    }

    public static BlockWrapper of() {
        return new BlockWrapper();
    }

    public static BlockWrapper of(CompatIdentifier id) {
        if (BlockUtil.isExist(id)) {
            return BlockWrapper.of(BlockUtil.fromId(id));
        }
        return BlockWrapper.of();
    }

    public static BlockWrapper of(CompatIdentifier id, CompatIdentifier ... ids) {
        if (BlockWrapper.of(id).isPresent()) {
            return BlockWrapper.of(id);
        }
        for (CompatIdentifier id1 : ids) {
            if (!BlockWrapper.of(id1).isPresent()) continue;
            return BlockWrapper.of(id1);
        }
        return BlockWrapper.of();
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    @Nullable
    public Block get() {
        return this.block;
    }

    public Block gerOrDefault(Block defaultItem) {
        return this.isEmpty() ? defaultItem : this.get();
    }

    public CompatIdentifier getId() {
        if (this.isEmpty()) {
            return CompatIdentifier.empty();
        }
        return BlockUtil.toId(this.get());
    }

    public String getName() {
        if (this.isEmpty()) {
            return "";
        }
        return BlockUtil.getNameAsString(this.get());
    }

    public String getTranslationKey() {
        if (this.isEmpty()) {
            return "";
        }
        return BlockUtil.getTranslationKey(this.get());
    }

    public ItemWrapper asItem() {
        if (this.isEmpty()) {
            return ItemWrapper.of();
        }
        return ItemWrapper.of(BlockUtil.toItem(this.get()));
    }

    public BlockState getDefaultState() {
        return BlockState.of(this.get());
    }

    public boolean rawEquals(BlockWrapper block) {
        return this.get() == block.get();
    }
}

