/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.server;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserWhiteList;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.World;

public class PlayerManager {
    private final PlayerList playerManager;

    protected PlayerManager(PlayerList playerManager) {
        this.playerManager = playerManager;
    }

    public static PlayerManager of(PlayerList playerManager) {
        return new PlayerManager(playerManager);
    }

    public static PlayerManager of(MinecraftServer server) {
        return PlayerManager.of(server.getPlayerList());
    }

    public static PlayerManager of(MCServer server) {
        return PlayerManager.of(server.getRaw());
    }

    public static PlayerManager of(ServerWorld world) {
        return PlayerManager.of(world.getServer());
    }

    public static PlayerManager of(World world) {
        return PlayerManager.of(world.getServer());
    }

    public PlayerList getRaw() {
        return this.playerManager;
    }

    public PlayerList toMinecraft() {
        return this.getRaw();
    }

    public void broadcast(TextComponent message, boolean overlay) {
        this.getRaw().broadcastSystemMessage(message.getText(), overlay);
    }

    public void broadcast(TextComponent message) {
        this.broadcast(message, false);
    }

    public void broadcast(String message, boolean overlay) {
        this.getRaw().broadcastSystemMessage((Component)TextUtil.literal(message), overlay);
    }

    public void broadcast(String message) {
        this.broadcast(message, false);
    }

    public void removePlayer(Player player) {
        this.getRaw().remove(player.getServerPlayer().get());
    }

    public Player getPlayerByUUID(UUID uuid) {
        return new Player((net.minecraft.world.entity.player.Player)this.getRaw().getPlayer(uuid));
    }

    public Player getPlayerByName(String name) {
        return new Player((net.minecraft.world.entity.player.Player)this.getRaw().getPlayerByName(name));
    }

    public List<Player> getPlayersByIP(String ip) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (net.minecraft.world.entity.player.Player p : this.getRaw().getPlayersWithAddress(ip)) {
            players.add(new Player(p));
        }
        return players;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (net.minecraft.world.entity.player.Player p : this.getRaw().getPlayers()) {
            players.add(new Player(p));
        }
        return players;
    }

    public boolean isExistByUUID(UUID uuid) {
        return this.getRaw().getPlayer(uuid) != null;
    }

    public boolean isExistByName(String name) {
        return this.getRaw().getPlayerByName(name) != null;
    }

    public boolean isExistByIP(String ip) {
        return !this.getRaw().getPlayersWithAddress(ip).isEmpty();
    }

    public boolean hasPlayerByUUID(UUID uuid) {
        return this.getRaw().getPlayer(uuid) != null;
    }

    public boolean hasPlayerByName(String name) {
        return this.getRaw().getPlayerByName(name) != null;
    }

    public boolean hasPlayerByIP(String ip) {
        return !this.getRaw().getPlayersWithAddress(ip).isEmpty();
    }

    public int getCurrentPlayerCount() {
        return this.getRaw().getPlayerCount();
    }

    public int getMaxPlayerCount() {
        return this.getRaw().getMaxPlayers();
    }

    public boolean isWhitelistEnabled() {
        return this.getRaw().isUsingWhitelist();
    }

    public void setWhitelistEnabled(boolean enabled) {
        this.getRaw().setUsingWhiteList(enabled);
    }

    public UserWhiteList getWhitelist() {
        return this.getRaw().getWhiteList();
    }

    public void reloadWhitelist() {
        this.getRaw().reloadWhiteList();
    }

    public IpBanList getBannedIpList() {
        return this.getRaw().getIpBans();
    }

    public UserBanList getBannedPlayerList() {
        return this.getRaw().getBans();
    }
}

