/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.SoundEventUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class EntityCollisionEvent
extends BaseEvent {
    public BlockState state;
    public Level world;
    public BlockPos pos;
    public Entity entity;
    public InsideBlockEffectApplier handler;

    public EntityCollisionEvent(BlockState state, Level world, BlockPos pos, Entity entity) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.entity = entity;
    }

    public EntityCollisionEvent(BlockState state, Level world, BlockPos pos, Entity entity, InsideBlockEffectApplier handler) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.entity = entity;
        this.handler = handler;
    }

    public boolean isClient() {
        return WorldUtil.isClient(this.world);
    }

    public BlockPos getEntityPos() {
        return this.entity.blockPosition();
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Level getWorld() {
        return this.world;
    }

    public void playSound(SoundEvent event, SoundSource category, float volume, float pitch) {
        WorldUtil.playSound(this.world, null, this.entity.blockPosition(), event, category, volume, pitch);
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        this.playSound(event, SoundSource.BLOCKS, volume, pitch);
    }

    public void playSound(SoundEvent event) {
        this.playSound(event, 1.0f, 1.0f);
    }

    public void playSound(SoundEvent event, SoundSource category) {
        this.playSound(event, category, 1.0f, 1.0f);
    }

    public void playSound(CompatIdentifier id, SoundSource category, float volume, float pitch) {
        this.playSound(SoundEventUtil.getSoundEvent(id), category, volume, pitch);
    }

    public boolean hasPlayerEntity() {
        return this.entity instanceof Player;
    }

    public Optional<Player> getPlayerEntity() {
        if (!this.hasPlayerEntity()) {
            return Optional.empty();
        }
        return Optional.of((Player)this.entity);
    }

    public BlockEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.getWorld(), this.getBlockPos());
    }

    public InsideBlockEffectApplier getHandler() {
        return this.handler;
    }
}

