/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.tool;

import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.pitan76.mcpitanlib.api.util.IngredientUtil;

public interface CompatibleToolMaterial {
    public int getCompatMiningLevel();

    public float getCompatAttackDamage();

    public float getCompatMiningSpeedMultiplier();

    default public Ingredient getCompatRepairIngredient() {
        return IngredientUtil.fromTagByIdentifier(this.getRepairTag().location());
    }

    public int getCompatDurability();

    public int getCompatEnchantability();

    default public TagKey<Block> getInverseTag() {
        return CompatibleToolMaterial.level2inverseTag(this.getCompatMiningLevel());
    }

    public static TagKey<Block> level2inverseTag(int level) {
        switch (level) {
            case 1: {
                return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
            }
            case 2: {
                return BlockTags.INCORRECT_FOR_STONE_TOOL;
            }
            case 3: {
                return BlockTags.INCORRECT_FOR_IRON_TOOL;
            }
            case 4: {
                return BlockTags.INCORRECT_FOR_GOLD_TOOL;
            }
            case 5: {
                return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
            }
            case 6: {
                return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
            }
        }
        return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
    }

    @Deprecated
    default public float getAttackDamage() {
        return this.getCompatAttackDamage();
    }

    @Deprecated
    default public float getMiningSpeedMultiplier() {
        return this.getCompatMiningSpeedMultiplier();
    }

    @Deprecated
    default public Ingredient getRepairIngredient() {
        return this.getCompatRepairIngredient();
    }

    @Deprecated
    default public int getDurability() {
        return this.getCompatDurability();
    }

    @Deprecated
    default public int getEnchantability() {
        return this.getCompatEnchantability();
    }

    default public TagKey<Item> getRepairTag() {
        return ItemTags.IRON_TOOL_MATERIALS;
    }

    default public ToolMaterial build() {
        return new ToolMaterial(this.getInverseTag(), this.getCompatDurability(), this.getCompatMiningSpeedMultiplier(), this.getCompatAttackDamage(), this.getCompatEnchantability(), this.getRepairTag());
    }
}

