/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.nbt.NbtListUtil;
import net.pitan76.mcpitanlib.core.mc1216.NbtDataConverter;

public class InventoryUtil {
    public static boolean insertItem(ItemStack insertStack, NonNullList<ItemStack> inventory) {
        return InventoryUtil.insertItem(insertStack, inventory, false);
    }

    public static boolean insertItem(ItemStack insertStack, NonNullList<ItemStack> inventory, boolean test) {
        boolean isInserted = false;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.isEmpty()) {
                if (!test) {
                    inventory.set(i, (Object)insertStack);
                }
                isInserted = true;
                break;
            }
            if (!InventoryUtil.canMergeItems(stack, insertStack)) continue;
            int j = insertStack.getCount();
            if (!test) {
                stack.grow(j);
            }
            isInserted = j > 0;
            break;
        }
        return isInserted;
    }

    public static boolean canMergeItems(ItemStack first, ItemStack second) {
        if (!first.is(second.getItem())) {
            return false;
        }
        if (first.getDamageValue() != second.getDamageValue()) {
            return false;
        }
        if (first.getCount() + second.getCount() > first.getMaxStackSize()) {
            return false;
        }
        return ItemStackUtil.areNbtOrComponentEqual(first, second);
    }

    public static CompoundTag writeNbt(NbtRWArgs args, CompoundTag nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        boolean nbtNull;
        boolean bl = nbtNull = nbt == null;
        if (args instanceof WriteNbtArgs) {
            WriteNbtArgs writeNbtArgs = (WriteNbtArgs)args;
            if (writeNbtArgs.view == null) {
                writeNbtArgs.view = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            }
            ContainerHelper.saveAllItems((ValueOutput)writeNbtArgs.view, stacks, (boolean)setIfEmpty);
            if (!nbtNull) {
                NbtUtil.put(nbt, "Items", (Tag)NbtListUtil.create());
            }
            NbtDataConverter.data2nbt(writeNbtArgs.view, nbt);
            return nbt;
        }
        ValueOutput view = NbtDataConverter.nbt2writeData(nbt, args.registryLookup);
        ContainerHelper.saveAllItems((ValueOutput)view, stacks, (boolean)setIfEmpty);
        if (!nbtNull) {
            NbtUtil.put(nbt, "Items", (Tag)NbtListUtil.create());
        }
        NbtDataConverter.data2nbt(view, nbt);
        return nbt;
    }

    public static void readNbt(NbtRWArgs args, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        if (args instanceof ReadNbtArgs) {
            ReadNbtArgs readNbtArgs = (ReadNbtArgs)args;
            if (readNbtArgs.view == null) {
                return;
            }
            ContainerHelper.loadAllItems((ValueInput)readNbtArgs.view, stacks);
            return;
        }
        ValueInput view = NbtDataConverter.nbt2readData(nbt, args.registryLookup);
        ContainerHelper.loadAllItems((ValueInput)view, stacks);
    }

    public static CompoundTag writeNbt(NbtRWArgs args, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        return InventoryUtil.writeNbt(args, args.getNbt(), stacks, setIfEmpty);
    }

    public static CompoundTag writeNbt(NbtRWArgs args, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(args, stacks, true);
    }

    public static void readNbt(NbtRWArgs args, NonNullList<ItemStack> stacks) {
        InventoryUtil.readNbt(args, args.getNbt(), stacks);
    }

    public static void readNbt(CompatRegistryLookup registryLookup, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        ValueInput view = NbtDataConverter.nbt2readData(nbt, registryLookup);
        ContainerHelper.loadAllItems((ValueInput)view, stacks);
    }

    public static CompoundTag writeNbt(CompatRegistryLookup registryLookup, CompoundTag nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        NbtUtil.put(nbt, "Items", (Tag)NbtListUtil.create());
        ValueOutput view = NbtDataConverter.nbt2writeData(nbt, registryLookup);
        ContainerHelper.saveAllItems((ValueOutput)view, stacks, (boolean)setIfEmpty);
        NbtDataConverter.data2nbt(view, nbt);
        System.out.println("writeNbt(): " + String.valueOf(nbt));
        return nbt;
    }

    public static CompoundTag writeNbt(CompatRegistryLookup registryLookup, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(registryLookup, nbt, stacks, true);
    }

    @Deprecated
    public static CompoundTag writeNbt(Level world, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(world, nbt, true, stacks);
    }

    @Deprecated
    public static CompoundTag writeNbt(Level world, CompoundTag nbt, boolean setIfEmpty, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(new NbtRWArgs(nbt), stacks, setIfEmpty);
    }

    @Deprecated
    public static void readNbt(Level world, CompoundTag nbt, NonNullList<ItemStack> stacks) {
        InventoryUtil.readNbt(new ReadNbtArgs(nbt), stacks);
    }

    public static SimpleContainer createSimpleInventory(int size) {
        return new SimpleContainer(size);
    }

    public static void copyToInv(NonNullList<ItemStack> from, Container to) {
        for (int i = 0; i < from.size(); ++i) {
            to.setItem(i, (ItemStack)from.get(i));
        }
    }

    public static void copyToList(Container from, NonNullList<ItemStack> to) {
        for (int i = 0; i < from.getContainerSize(); ++i) {
            to.set(i, (Object)from.getItem(i));
        }
    }

    public static int getSize(Container inventory) {
        return inventory.getContainerSize();
    }

    public static ItemStack getStack(Container inventory, int slot) {
        return inventory.getItem(slot);
    }

    public static void setStack(Container inventory, int slot, ItemStack stack) {
        inventory.setItem(slot, stack);
    }

    public static boolean isEmpty(Container inventory) {
        return inventory.isEmpty();
    }

    public static ItemStack removeStack(Container inventory, int slot) {
        return inventory.removeItemNoUpdate(slot);
    }

    public static ItemStack removeStack(Container inventory, int slot, int amount) {
        return inventory.removeItem(slot, amount);
    }

    public static void clear(Container inventory) {
        inventory.clearContent();
    }

    public static void markDirty(Container inventory) {
        inventory.setChanged();
    }
}

