/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.core.mc1216;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class NbtDataConverter {
    public static void nbt2writeData(CompoundTag nbt, ValueOutput view) {
        if (nbt == null || view == null) {
            return;
        }
        ArrayList keys = new ArrayList(nbt.keySet());
        for (String key : keys) {
            Tag value = nbt.get(key);
            if (value == null) continue;
            byte type = value.getId();
            view.putByte("__nbttype_" + key + "__", type);
            switch (type) {
                case 1: {
                    Optional optional = value.asByte();
                    if (optional.isEmpty()) break;
                    view.putByte(key, ((Byte)optional.get()).byteValue());
                    break;
                }
                case 2: {
                    Optional optionalShort = value.asShort();
                    if (optionalShort.isEmpty()) break;
                    view.putShort(key, ((Short)optionalShort.get()).shortValue());
                    break;
                }
                case 3: {
                    Optional optionalInt = value.asInt();
                    if (optionalInt.isEmpty()) break;
                    view.putInt(key, ((Integer)optionalInt.get()).intValue());
                    break;
                }
                case 4: {
                    Optional optionalLong = value.asLong();
                    if (optionalLong.isEmpty()) break;
                    view.putLong(key, ((Long)optionalLong.get()).longValue());
                    break;
                }
                case 5: {
                    Optional optionalFloat = value.asFloat();
                    if (optionalFloat.isEmpty()) break;
                    view.putFloat(key, ((Float)optionalFloat.get()).floatValue());
                    break;
                }
                case 6: {
                    Optional optionalDouble = value.asDouble();
                    if (optionalDouble.isEmpty()) break;
                    view.putDouble(key, ((Double)optionalDouble.get()).doubleValue());
                    break;
                }
                case 8: {
                    Optional optionalString = value.asString();
                    if (optionalString.isEmpty()) break;
                    view.putString(key, (String)optionalString.get());
                    break;
                }
                case 7: {
                    Optional optionalByteArray = value.asByteArray();
                    if (optionalByteArray.isEmpty()) break;
                    byte[] byteArray = (byte[])optionalByteArray.get();
                    int[] intArray = new int[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        intArray[i] = byteArray[i];
                    }
                    view.putIntArray(key, intArray);
                    break;
                }
                case 11: {
                    Optional optionalIntArray = value.asIntArray();
                    if (optionalIntArray.isEmpty()) break;
                    view.putIntArray(key, (int[])optionalIntArray.get());
                    break;
                }
                case 12: {
                    Optional optionalLongArray = value.asLongArray();
                    if (optionalLongArray.isEmpty()) break;
                    long[] longArray = (long[])optionalLongArray.get();
                    int[] longIntArray = new int[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        longIntArray[i] = (int)(longArray[i] & 0xFFFFFFFFL);
                    }
                    view.putIntArray(key, longIntArray);
                    break;
                }
                case 10: {
                    Optional optionalCompound = value.asCompound();
                    if (optionalCompound.isEmpty()) break;
                    CompoundTag nbt2 = (CompoundTag)optionalCompound.get();
                    view.store(key, CompoundTag.CODEC, (Object)nbt2);
                }
            }
        }
        view.putString("__all_keys__", String.join((CharSequence)",", keys));
    }

    public static void data2nbt(ValueInput view, CompoundTag nbt) {
        String[] keys;
        if (view == null || nbt == null) {
            return;
        }
        String keysStr = view.getStringOr("__all_keys__", "");
        if (keysStr.isEmpty()) {
            return;
        }
        block13: for (String key : keys = keysStr.split(",")) {
            byte type;
            if (key == null || key.isEmpty() || (type = view.getByteOr("__nbttype_" + key + "__", (byte)-1)) == -1) continue;
            switch (type) {
                case 1: {
                    nbt.putByte(key, view.getByteOr(key, (byte)0));
                    continue block13;
                }
                case 2: {
                    nbt.putShort(key, (short)view.getShortOr(key, (short)0));
                    continue block13;
                }
                case 3: {
                    nbt.putInt(key, view.getIntOr(key, 0));
                    continue block13;
                }
                case 4: {
                    nbt.putLong(key, view.getLongOr(key, 0L));
                    continue block13;
                }
                case 5: {
                    nbt.putFloat(key, view.getFloatOr(key, 0.0f));
                    continue block13;
                }
                case 6: {
                    nbt.putDouble(key, view.getDoubleOr(key, 0.0));
                    continue block13;
                }
                case 8: {
                    nbt.putString(key, view.getStringOr(key, ""));
                    continue block13;
                }
                case 7: {
                    int[] intArray = (int[])view.getIntArray(key).get();
                    byte[] byteArray = new byte[intArray.length];
                    for (int i = 0; i < intArray.length; ++i) {
                        byteArray[i] = (byte)intArray[i];
                    }
                    nbt.putByteArray(key, byteArray);
                    continue block13;
                }
                case 11: {
                    nbt.putIntArray(key, (int[])view.getIntArray(key).get());
                    continue block13;
                }
                case 12: {
                    int[] longIntArray = (int[])view.getIntArray(key).get();
                    long[] longArray = new long[longIntArray.length];
                    for (int i = 0; i < longIntArray.length; ++i) {
                        longArray[i] = (long)longIntArray[i] & 0xFFFFFFFFL;
                    }
                    nbt.putLongArray(key, longArray);
                    continue block13;
                }
                case 10: {
                    CompoundTag nbt2 = (CompoundTag)view.read(key, CompoundTag.CODEC).get();
                    nbt.put(key, (Tag)nbt2);
                    continue block13;
                }
                default: {
                    nbt.putString(key, "Unsupported NBT type: " + type);
                }
            }
        }
    }

    public static void data2nbt(ValueOutput view, CompoundTag nbt) {
        if (view == null || nbt == null) {
            return;
        }
        if (view instanceof TagValueOutput) {
            NbtUtil.copyFrom(((TagValueOutput)view).buildResult(), nbt);
        }
    }

    public static ValueOutput nbt2writeData(CompoundTag nbt, CompatRegistryLookup registryLookup) {
        TagValueOutput view = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        NbtDataConverter.nbt2writeData(nbt, (ValueOutput)view);
        return view;
    }

    public static ValueInput nbt2readData(CompoundTag nbt, CompatRegistryLookup registryLookup) {
        if (nbt == null) {
            nbt = NbtUtil.create();
        }
        return TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registryLookup.getRegistryLookup(), (CompoundTag)nbt);
    }

    public static CompoundTag data2nbt(ValueInput view) {
        CompoundTag nbt = new CompoundTag();
        NbtDataConverter.data2nbt(view, nbt);
        return nbt;
    }

    public static CompoundTag data2nbt(ValueOutput view) {
        CompoundTag nbt = new CompoundTag();
        NbtDataConverter.data2nbt(view, nbt);
        return nbt;
    }
}

