/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.component;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.pitan76.mcpitanlib.api.item.stack.LoreUtil;
import net.pitan76.mcpitanlib.api.util.BlockEntityDataUtil;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.midohra.component.item.CustomNameComponentType;
import net.pitan76.mcpitanlib.midohra.component.item.ItemComponentType;
import net.pitan76.mcpitanlib.midohra.component.item.RarityComponentType;

public class ItemComponentTypes {
    public static final ItemComponentType<CompoundTag> CUSTOM_DATA = new ItemComponentType<CompoundTag>(DataComponents.CUSTOM_DATA){

        @Override
        public void put(ItemStack stack, CompoundTag value) {
            CustomDataUtil.setNbt(stack, value);
        }

        @Override
        public CompoundTag get(ItemStack stack) {
            return CustomDataUtil.getNbt(stack);
        }
    };
    public static final ItemComponentType<Integer> MAX_STACK_SIZE = new ItemComponentType<Integer>(DataComponents.MAX_STACK_SIZE){

        @Override
        public void put(ItemStack stack, Integer value) {
            stack.set(DataComponents.MAX_STACK_SIZE, (Object)value);
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.getMaxStackSize();
        }
    };
    public static final ItemComponentType<Integer> MAX_DAMAGE = new ItemComponentType<Integer>(DataComponents.MAX_DAMAGE){

        @Override
        public void put(ItemStack stack, Integer value) {
            stack.set(DataComponents.MAX_DAMAGE, (Object)value);
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.getMaxDamage();
        }
    };
    public static final ItemComponentType<Integer> DAMAGE = new ItemComponentType<Integer>(DataComponents.DAMAGE){

        @Override
        public void put(ItemStack stack, Integer value) {
            stack.setDamageValue(value.intValue());
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.getDamageValue();
        }
    };
    public static final ItemComponentType<Boolean> UNBREAKABLE = new ItemComponentType<Boolean>(DataComponents.UNBREAKABLE){

        @Override
        public void put(ItemStack stack, Boolean value) {
            if (value.booleanValue()) {
                stack.set(DataComponents.UNBREAKABLE, (Object)Unit.valueOf((String)""));
            } else {
                stack.remove(DataComponents.UNBREAKABLE);
            }
        }

        @Override
        public Boolean get(ItemStack stack) {
            return this.has(stack);
        }
    };
    public static final ItemComponentType<Rarity> RARITY = new RarityComponentType();
    public static final CustomNameComponentType CUSTOM_NAME = new CustomNameComponentType();
    public static final ItemComponentType<CompoundTag> BLOCK_ENTITY_DATA = new ItemComponentType<CompoundTag>(DataComponents.BLOCK_ENTITY_DATA){

        @Override
        public void put(ItemStack stack, CompoundTag value) {
            BlockEntityDataUtil.setBlockEntityNbt(stack, value);
        }

        @Override
        public CompoundTag get(ItemStack stack) {
            return BlockEntityDataUtil.getBlockEntityNbt(stack);
        }
    };
    public static final ItemComponentType<CompoundTag> ENTITY_DATA = new ItemComponentType<CompoundTag>(DataComponents.ENTITY_DATA){

        @Override
        public void put(ItemStack stack, CompoundTag value) {
            stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)value));
        }

        @Override
        public CompoundTag get(ItemStack stack) {
            if (!this.has(stack)) {
                return NbtUtil.create();
            }
            return ((CustomData)stack.get(DataComponents.ENTITY_DATA)).copyTag();
        }
    };
    public static final ItemComponentType<List<Component>> LORE = new ItemComponentType<List<Component>>(DataComponents.LORE){

        @Override
        public void put(ItemStack stack, List<Component> value) {
            LoreUtil.setLore(stack, value);
        }

        @Override
        public List<Component> get(ItemStack stack) {
            return LoreUtil.getLore(stack);
        }
    };
}

