/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world.chunk;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;

public class ChunkTicketType<T> {
    public static final ChunkTicketType<Unit> START = ChunkTicketType.of(TicketType.START);
    public static final ChunkTicketType<Unit> DRAGON = ChunkTicketType.of(TicketType.DRAGON);
    public static final ChunkTicketType<ChunkPos> PLAYER = ChunkTicketType.of(TicketType.PLAYER_SIMULATION);
    public static final ChunkTicketType<ChunkPos> FORCED = ChunkTicketType.of(TicketType.FORCED);
    public static final ChunkTicketType<BlockPos> PORTAL = ChunkTicketType.of(TicketType.PORTAL);
    public static final ChunkTicketType<ChunkPos> ENDER_PEARL = ChunkTicketType.of(TicketType.ENDER_PEARL);
    public static final ChunkTicketType<Integer> POST_TELEPORT = ChunkTicketType.of(TicketType.PORTAL);
    public static final ChunkTicketType<ChunkPos> UNKNOWN = ChunkTicketType.of(TicketType.UNKNOWN);
    private final TicketType ticketType;

    protected ChunkTicketType(TicketType ticketType) {
        this.ticketType = ticketType;
    }

    public static <T> ChunkTicketType<T> of(TicketType ticketType) {
        return new ChunkTicketType<T>(ticketType);
    }

    public TicketType getRaw() {
        return this.ticketType;
    }

    public TicketType toMinecraft() {
        return this.getRaw();
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator) {
        return ChunkTicketType.create(name);
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator, int expiryTicks) {
        return ChunkTicketType.create(name, expiryTicks);
    }

    public Comparator<T> getArgumentComparator() {
        return null;
    }

    public long getExpiryTicks() {
        return this.getRaw().timeout();
    }

    public String toString() {
        return this.getRaw().toString();
    }

    public ChunkTicketType(String name, long expiryTicks) {
        this(new TicketType(expiryTicks, true, TicketType.TicketUse.LOADING_AND_SIMULATION));
    }

    public ChunkTicketType(String name) {
        this(name, 0L);
    }

    public static ChunkTicketType<ChunkPos> create(String name, long expiryTicks) {
        return new ChunkTicketType<ChunkPos>(name, expiryTicks);
    }

    public static ChunkTicketType<ChunkPos> create(String name) {
        return new ChunkTicketType<ChunkPos>(name);
    }

    public int hashCode() {
        return this.ticketType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChunkTicketType)) {
            return false;
        }
        ChunkTicketType that = (ChunkTicketType)obj;
        return this.ticketType.equals((Object)that.ticketType);
    }
}

