/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world.chunk;

import net.minecraft.server.level.ServerChunkCache;
import net.pitan76.mcpitanlib.api.util.world.ChunkManagerUtil;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.util.math.ChunkPos;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.mcpitanlib.midohra.world.chunk.ChunkManager;
import net.pitan76.mcpitanlib.midohra.world.chunk.ChunkTicketType;

public class ServerChunkManager
extends ChunkManager {
    private final ServerChunkCache chunkManager;

    protected ServerChunkManager(ServerChunkCache chunkManager) {
        super(null);
        this.chunkManager = chunkManager;
    }

    public static ServerChunkManager of(ServerChunkCache chunkManager) {
        return new ServerChunkManager(chunkManager);
    }

    public static ServerChunkManager of(ServerWorld world) {
        return ServerChunkManager.of(world.getRaw().getChunkSource());
    }

    public ServerChunkCache getRaw() {
        return this.chunkManager;
    }

    public ServerChunkCache toMinecraft() {
        return this.getRaw();
    }

    @Override
    public World getWorld() {
        return World.of(this.getRaw().getLevel());
    }

    public <T> void addTicket(ChunkTicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.getRaw().addTicketWithRadius(ticketType.getRaw(), pos.getRaw(), radius);
    }

    public <T> void removeTicket(ChunkTicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.getRaw().removeTicketWithRadius(ticketType.getRaw(), pos.getRaw(), radius);
    }

    public void markForUpdate(BlockPos pos) {
        ChunkManagerUtil.markForUpdate(this.getRaw(), pos);
    }
}

