/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.event.listener;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.util.VoxelShapeUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public interface WorldRenderContext {
    public LevelRenderer getWorldRenderer();

    public PoseStack getMatrixStack();

    public float getTickDelta();

    public Camera getCamera();

    public GameRenderer getGameRenderer();

    public LightTexture getLightmapTextureManager();

    @Deprecated
    public Matrix4f getProjectionMatrix();

    public ClientLevel getWorld();

    @Deprecated
    public boolean isAdvancedTranslucency();

    @Nullable
    public MultiBufferSource getConsumers();

    @Nullable
    public Frustum getFrustum();

    default public HitResult getHitResult() {
        return Minecraft.getInstance().hitResult;
    }

    default public Optional<BlockState> getBlockState() {
        return Optional.ofNullable(this.getWorld().getBlockState((BlockPos)this.getBlockPos().orElse(null)));
    }

    default public Optional<BlockPos> getBlockPos() {
        return Optional.ofNullable(((BlockHitResult)this.getHitResult()).getBlockPos());
    }

    default public boolean isBlockType() {
        return this.getHitResultType() == HitResult.Type.BLOCK;
    }

    default public HitResult.Type getHitResultType() {
        return this.getHitResult().getType();
    }

    default public Optional<VoxelShape> getOutlineShape() {
        return this.getBlockState().map(blockState -> blockState.getShape((BlockGetter)this.getWorld(), (BlockPos)this.getBlockPos().orElse(null)));
    }

    default public void push() {
        this.getMatrixStack().pushPose();
    }

    default public void translate(double x, double y, double z) {
        this.getMatrixStack().translate(x, y, z);
    }

    default public void pop() {
        this.getMatrixStack().popPose();
    }

    default public Optional<VertexConsumer> getVertexConsumer() {
        if (this.getConsumers() == null) {
            return Optional.empty();
        }
        return Optional.of(Objects.requireNonNull(this.getConsumers()).getBuffer(RenderType.lines()));
    }

    default public void drawBox(float red, float green, float blue, float alpha) {
        Optional<VoxelShape> outlineShape = this.getOutlineShape();
        if (!outlineShape.isPresent()) {
            return;
        }
        this.drawBox(VoxelShapeUtil.getBoundingBox(outlineShape.get()), red, green, blue, alpha);
    }

    default public void drawBox(AABB box, float red, float green, float blue, float alpha) {
        Optional<VertexConsumer> vertexConsumer = this.getVertexConsumer();
        if (!vertexConsumer.isPresent()) {
            return;
        }
        LevelRenderer.renderLineBox((PoseStack)this.getMatrixStack(), (VertexConsumer)vertexConsumer.get(), (AABB)box, (float)red, (float)green, (float)blue, (float)alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface BlockOutlineContext {
        @Deprecated
        public VertexConsumer vertexConsumer();

        public Entity entity();

        public double cameraX();

        public double cameraY();

        public double cameraZ();

        public BlockPos blockPos();

        public BlockState blockState();
    }
}

