/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.gui.args.CreateMenuEvent;
import net.pitan76.mcpitanlib.api.gui.args.SlotClickEvent;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ScreenHandlerUtil;
import net.pitan76.mcpitanlib.api.util.SlotUtil;
import org.jetbrains.annotations.Nullable;

public class SimpleScreenHandler
extends AbstractContainerMenu {
    public boolean hasMainInventory = false;
    public boolean hasHotbar = false;
    public static final int DEFAULT_SLOT_SIZE = 18;

    protected SimpleScreenHandler(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    protected SimpleScreenHandler(@Nullable MenuType<?> type, CreateMenuEvent e) {
        this(type, e.getSyncId());
    }

    @Deprecated
    public boolean stillValid(Player player) {
        return this.canUse(new net.pitan76.mcpitanlib.api.entity.Player(player));
    }

    public boolean canUse(net.pitan76.mcpitanlib.api.entity.Player player) {
        return true;
    }

    public Slot addNormalSlot(Container inventory, int index, int x, int y) {
        Slot slot = new Slot(inventory, index, x, y);
        return this.addSlot(slot);
    }

    public <T extends Slot> Slot addSlot(Container inventory, int index, int x, int y, SlotFactory<T> factory) {
        T slot = factory.create(inventory, index, x, y);
        return this.addSlot((Slot)slot);
    }

    public Slot callAddSlot(Slot slot) {
        return this.addSlot(slot);
    }

    @Deprecated
    protected Slot addSlot(Slot slot) {
        return super.addSlot(slot);
    }

    @Deprecated
    public void removed(Player player) {
        this.close(new net.pitan76.mcpitanlib.api.entity.Player(player));
    }

    public void close(net.pitan76.mcpitanlib.api.entity.Player player) {
        super.removed(player.getPlayerEntity());
    }

    protected List<Slot> addPlayerMainInventorySlots(Inventory inventory, int x, int y) {
        this.hasMainInventory = true;
        return this.addSlots((Container)inventory, 9, x, y, 18, 9, 3);
    }

    protected List<Slot> addPlayerHotbarSlots(Inventory inventory, int x, int y) {
        this.hasHotbar = true;
        return this.addSlotsX((Container)inventory, 0, x, y, 18, 9);
    }

    protected List<Slot> addSlots(Container inventory, int firstIndex, int firstX, int firstY, int size, int maxAmountX, int maxAmountY) {
        if (size < 0) {
            size = 18;
        }
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int y = 0; y < maxAmountY; ++y) {
            List<Slot> xSlots = this.addSlotsX(inventory, firstIndex + y * maxAmountX, firstX, firstY + y * size, size, maxAmountX);
            slots.addAll(xSlots);
        }
        return slots;
    }

    protected List<Slot> addSlotsX(Container inventory, int firstIndex, int firstX, int y, int size, int amount) {
        if (size < 0) {
            size = 18;
        }
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int x = 0; x < amount; ++x) {
            Slot slot = this.addNormalSlot(inventory, firstIndex + x, firstX + x * size, y);
            slots.add(slot);
        }
        return slots;
    }

    protected List<Slot> addSlotsY(Container inventory, int firstIndex, int x, int firstY, int size, int amount) {
        if (size < 0) {
            size = 18;
        }
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int y = 0; y < amount; ++y) {
            Slot slot = this.addNormalSlot(inventory, firstIndex + x, x, firstY + y * size);
            slots.add(slot);
        }
        return slots;
    }

    @Deprecated
    public ItemStack quickMoveOverride(Player player, int index) {
        return this.quickMoveOverride(new net.pitan76.mcpitanlib.api.entity.Player(player), index);
    }

    public boolean callInsertItem(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        return this.moveItemStackTo(stack, startIndex, endIndex, fromLast);
    }

    @Deprecated
    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        return super.moveItemStackTo(stack, startIndex, endIndex, fromLast);
    }

    public ItemStack quickMoveOverride(net.pitan76.mcpitanlib.api.entity.Player player, int index) {
        ItemStack itemStack = ItemStackUtil.empty();
        Slot slot = ScreenHandlerUtil.getSlot(this, index);
        int size = ScreenHandlerUtil.getSlots(this).size();
        if (SlotUtil.hasStack(slot)) {
            ItemStack itemStack2 = SlotUtil.getStack(slot);
            itemStack = itemStack2.copy();
            if (this.hasMainInventory && this.hasHotbar && (index > 35 ? !this.callInsertItem(itemStack2, 0, 9, false) && !this.callInsertItem(itemStack2, 9, 36, true) : size > 36 && !this.callInsertItem(itemStack2, 36, size, false))) {
                return ItemStackUtil.empty();
            }
            if (itemStack2.isEmpty()) {
                SlotUtil.setStack(slot, ItemStackUtil.empty());
            } else {
                SlotUtil.markDirty(slot);
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStackUtil.empty();
            }
            SlotUtil.onTakeItem(slot, player, itemStack2);
        }
        return itemStack;
    }

    @Deprecated
    public ItemStack quickMoveStack(Player player, int slot) {
        return this.quickMoveOverride(player, slot);
    }

    @Deprecated
    public Slot getSlot(int index) {
        return this.callGetSlot(index);
    }

    public Slot callGetSlot(int index) {
        return super.getSlot(index);
    }

    @Deprecated
    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        this.overrideOnSlotClick(slotIndex, button, actionType, new net.pitan76.mcpitanlib.api.entity.Player(player));
    }

    public void overrideOnSlotClick(int slotIndex, int button, ClickType actionType, net.pitan76.mcpitanlib.api.entity.Player player) {
        this.onSlotClick(new SlotClickEvent(slotIndex, button, actionType, player));
    }

    public void onSlotClick(SlotClickEvent e) {
        super.clicked(e.slot, e.button, e.actionType, e.player.getEntity());
    }

    @Deprecated
    public void setCarried(ItemStack stack) {
        this.callSetCursorStack(stack);
    }

    public void callSetCursorStack(ItemStack stack) {
        super.setCarried(stack);
    }

    @Deprecated
    public void setItem(int slot, int revision, ItemStack stack) {
        this.callSetStackInSlot(slot, revision, stack);
    }

    public void callSetStackInSlot(int slot, int revision, ItemStack stack) {
        super.setItem(slot, revision, stack);
    }

    @Deprecated
    public int getStateId() {
        return this.callGetRevision();
    }

    public int callGetRevision() {
        return super.getStateId();
    }

    public static interface SlotFactory<T extends Slot> {
        public T create(Container var1, int var2, int var3, int var4);
    }
}

