/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.pitan76.mcpitanlib.api.item.ArmorEquipmentType;
import net.pitan76.mcpitanlib.api.item.CompatibleArmorItem;

public interface CompatibleArmorMaterial {
    public int getDurability(ArmorEquipmentType var1);

    public int getProtection(ArmorEquipmentType var1);

    public int getEnchantability();

    public SoundEvent getEquipSound();

    public Ingredient getRepairIngredient();

    default public String getName() {
        return this.getId().getPath();
    }

    public ResourceLocation getId();

    public float getToughness();

    public float getKnockbackResistance();

    @Deprecated
    default public Holder<ArmorMaterial> build() {
        if (CompatibleArmorItem.CACHE.containsKey(this)) {
            return CompatibleArmorItem.CACHE.get(this);
        }
        Holder<ArmorMaterial> entry = CompatibleArmorMaterial.register(this.getId(), (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.HELMET, this.getProtection(ArmorEquipmentType.HEAD));
            map.put(ArmorItem.Type.CHESTPLATE, this.getProtection(ArmorEquipmentType.CHEST));
            map.put(ArmorItem.Type.LEGGINGS, this.getProtection(ArmorEquipmentType.LEGS));
            map.put(ArmorItem.Type.BOOTS, this.getProtection(ArmorEquipmentType.FEET));
            map.put(ArmorItem.Type.BODY, this.getProtection(ArmorEquipmentType.BODY));
        }), this.getEnchantability(), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, this.getToughness(), this.getKnockbackResistance(), this::getRepairIngredient);
        CompatibleArmorItem.CACHE.put(this, entry);
        return entry;
    }

    private static Holder<ArmorMaterial> register(ResourceLocation id, EnumMap<ArmorItem.Type, Integer> defense, int enchantability, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(id));
        return CompatibleArmorMaterial.register(id, defense, enchantability, equipSound, toughness, knockbackResistance, repairIngredient, list);
    }

    private static Holder<ArmorMaterial> register(ResourceLocation id, EnumMap<ArmorItem.Type, Integer> defense, int enchantability, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient, List<ArmorMaterial.Layer> layers) {
        ArmorItem.Type[] var9;
        EnumMap<ArmorItem.Type, Integer> enumMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : var9 = ArmorItem.Type.values()) {
            enumMap.put(type, defense.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)id, (Object)new ArmorMaterial(enumMap, enchantability, equipSound, repairIngredient, layers, toughness, knockbackResistance));
    }
}

