/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network;

import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.pitan76.mcpitanlib.core.network.BufPayload;

public class ServerNetworking {
    private static final List<ResourceLocation> registeredList = new ArrayList<ResourceLocation>();

    public static void send(ServerPlayer player, ResourceLocation identifier, FriendlyByteBuf buf) {
        ServerNetworking.registerS2CPayloadType(identifier);
        BufPayload payload = new BufPayload(buf, identifier);
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload);
    }

    public static void send(Iterable<ServerPlayer> players, ResourceLocation identifier, FriendlyByteBuf buf) {
        ServerNetworking.registerS2CPayloadType(identifier);
        BufPayload payload = new BufPayload(buf, identifier);
        NetworkManager.sendToPlayers(players, (CustomPacketPayload)payload);
    }

    public static void sendAll(MinecraftServer server, ResourceLocation identifier, FriendlyByteBuf buf) {
        ServerNetworking.send(server.getPlayerList().getPlayers(), identifier, buf);
    }

    public static void registerReceiver(ResourceLocation identifier, ServerNetworkHandler handler) {
        CustomPacketPayload.Type<BufPayload> id = BufPayload.id(identifier);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, id, BufPayload.getCodec(id), (payload, context) -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload.getData()));
            ServerPlayer player = null;
            if (context.getPlayer() instanceof ServerPlayer) {
                player = (ServerPlayer)context.getPlayer();
            }
            handler.receive(context.getPlayer().getServer(), player, buf);
            buf.release();
        });
    }

    public static void registerS2CPayloadType(ResourceLocation identifier) {
        if (registeredList.contains(identifier)) {
            return;
        }
        registeredList.add(identifier);
        if (NetworkAggregator.S2C_CODECS.containsKey(identifier)) {
            return;
        }
        CustomPacketPayload.Type<BufPayload> id = BufPayload.id(identifier);
        NetworkManager.registerS2CPayloadType(id, BufPayload.getCodec(id));
    }

    @FunctionalInterface
    public static interface ServerNetworkHandler {
        public void receive(MinecraftServer var1, ServerPlayer var2, FriendlyByteBuf var3);
    }
}

