/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.inventory.ICompatInventory;

public class ClippedInventory
implements Container,
ICompatInventory {
    private final Container inventory;
    private final int start;
    private final int end;

    public static ClippedInventory of(Container inventory, int start, int end) {
        if (start < 0 || end > inventory.getContainerSize() || start >= end) {
            throw new IllegalArgumentException("Invalid start or end indices for clipping inventory.");
        }
        return new ClippedInventory(inventory, start, end);
    }

    public static ClippedInventory of(Container inventory) {
        return ClippedInventory.of(inventory, 0, inventory.getContainerSize());
    }

    public static ClippedInventory of(Container inventory, int start) {
        return ClippedInventory.of(inventory, start, inventory.getContainerSize());
    }

    public ClippedInventory(Container inventory, int start, int end) {
        this.inventory = inventory;
        this.start = start;
        this.end = end;
    }

    public int getContainerSize() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        for (int i = this.start; i < this.end; ++i) {
            if (this.inventory.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getItem(this.start + slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.inventory.removeItem(this.start + slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.inventory.removeItemNoUpdate(this.start + slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setItem(this.start + slot, stack);
    }

    public void setChanged() {
        this.inventory.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void clearContent() {
        for (int i = this.start; i < this.end; ++i) {
            this.inventory.setItem(i, ItemStackUtil.empty());
        }
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }
}

