/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.util.hit;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.midohra.util.hit.BlockHitResult;
import net.pitan76.mcpitanlib.midohra.util.hit.HitResultType;

public class HitResult {
    protected final net.minecraft.world.phys.HitResult raw;

    public HitResult(net.minecraft.world.phys.HitResult raw) {
        this.raw = raw;
    }

    public static HitResult of(net.minecraft.world.phys.HitResult raw) {
        return new HitResult(raw);
    }

    @Deprecated
    public net.minecraft.world.phys.HitResult getRaw() {
        return this.raw;
    }

    @Deprecated
    public HitResult.Type getRawType() {
        return this.getRaw().getType();
    }

    public Vec3 getPos() {
        return this.getRaw().getLocation();
    }

    public double getX() {
        return this.pos().x;
    }

    public double getY() {
        return this.pos().y;
    }

    public double getZ() {
        return this.pos().z;
    }

    public HitResultType getType() {
        return HitResultType.of(this);
    }

    public double squaredDistanceTo(Vec3 point) {
        Vec3 hitPos = this.getPos();
        double dx = hitPos.x - point.x;
        double dy = hitPos.y - point.y;
        double dz = hitPos.z - point.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double squaredDistanceTo(Entity entity) {
        return this.getRaw().distanceTo(entity);
    }

    public Vec3 pos() {
        return this.getPos();
    }

    public double x() {
        return this.getX();
    }

    public double y() {
        return this.getY();
    }

    public double z() {
        return this.getZ();
    }

    public Optional<BlockHitResult> asBlockHitResult() {
        if (this instanceof BlockHitResult) {
            return Optional.of((BlockHitResult)this);
        }
        if (this.raw instanceof net.minecraft.world.phys.BlockHitResult) {
            return Optional.of(BlockHitResult.of((net.minecraft.world.phys.BlockHitResult)this.raw));
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HitResult other = (HitResult)obj;
        return this.getRaw().equals(other.getRaw());
    }

    public int hashCode() {
        return this.getRaw().hashCode();
    }

    public String toString() {
        return this.getRaw().toString();
    }
}

