/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.stack;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;

public class LoreUtil {
    public static boolean hasLore(ItemStack stack) {
        return stack.has(DataComponents.LORE);
    }

    public static List<Component> getLore(ItemStack stack) {
        if (!LoreUtil.hasLore(stack)) {
            return List.of();
        }
        return ((ItemLore)stack.get(DataComponents.LORE)).lines();
    }

    public static List<String> getLoreAsStringList(ItemStack stack) {
        return LoreUtil.getLore(stack).stream().map(Component::getString).toList();
    }

    public static String getLoreAsString(ItemStack stack) {
        return LoreUtil.getLoreAsStringList(stack).stream().reduce("", (a, b) -> a + "\n" + b);
    }

    public static void setLore(ItemStack stack, List<Component> lore) {
        stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
    }

    public static void setLoreStringList(ItemStack stack, List<String> lore) {
        LoreUtil.setLore(stack, lore.stream().map(Component::nullToEmpty).toList());
    }

    public static void setLore(ItemStack stack, String lore) {
        LoreUtil.setLore(stack, lore.lines().map(Component::nullToEmpty).toList());
    }
}

