/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.resources.ResourceLocation;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;

public class CompatIdentifier {
    private final String namespace;
    private final String path;
    public static final CompatIdentifier EMPTY = CompatIdentifier.of("mcpitanlib:empty");

    public CompatIdentifier(String namespace, String path) {
        this.namespace = namespace;
        this.path = path;
    }

    public CompatIdentifier(String id) {
        if (!id.contains(":")) {
            this.namespace = "minecraft";
            this.path = id;
            return;
        }
        String[] split = id.split(":");
        this.namespace = split[0];
        this.path = split[1];
    }

    public static CompatIdentifier of(String id) {
        return new CompatIdentifier(id);
    }

    public static CompatIdentifier of(String namespace, String path) {
        return new CompatIdentifier(namespace, path);
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            CompatIdentifier identifier = (CompatIdentifier)obj;
            return this.namespace.equals(identifier.namespace) && this.path.equals(identifier.path);
        }
        if (obj instanceof ResourceLocation) {
            return this.toString().equals(obj.toString());
        }
        if (obj instanceof String) {
            return this.toString().equals(obj);
        }
        return false;
    }

    public boolean equals(CompatIdentifier identifier) {
        return this.namespace.equals(identifier.namespace) && this.path.equals(identifier.path);
    }

    public boolean equals(String id) {
        return this.toString().equals(id);
    }

    public static boolean equals(CompatIdentifier id1, CompatIdentifier id2) {
        return id1.namespace.equals(id2.namespace) && id1.path.equals(id2.path);
    }

    public static boolean equals(CompatIdentifier id1, ResourceLocation id2) {
        return id1.toString().equals(id2.toString());
    }

    public static boolean equals(ResourceLocation id1, CompatIdentifier id2) {
        return id1.toString().equals(id2.toString());
    }

    public static boolean equals(ResourceLocation id1, ResourceLocation id2) {
        return id1.toString().equals(id2.toString());
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    public ResourceLocation toMinecraft() {
        return IdentifierUtil.id(this.toString());
    }

    public static CompatIdentifier fromMinecraft(ResourceLocation id) {
        if (id == null) {
            return EMPTY;
        }
        return CompatIdentifier.of(id.toString());
    }

    public static CompatIdentifier empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public static boolean isMinecraftNamespace(CompatIdentifier id) {
        return id.getNamespace().equals("minecraft");
    }
}

