/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.util.TextUtil;

public class PlayerUtil {
    public static Player getPlayerByUUID(MinecraftServer server, UUID uuid) {
        return new Player((net.minecraft.world.entity.player.Player)server.getPlayerList().getPlayer(uuid));
    }

    public static Player getPlayerByName(MinecraftServer server, String name) {
        return new Player((net.minecraft.world.entity.player.Player)server.getPlayerList().getPlayerByName(name));
    }

    public static List<Player> getPlayersByIP(MinecraftServer server, String ip) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (net.minecraft.world.entity.player.Player p : server.getPlayerList().getPlayersWithAddress(ip)) {
            players.add(new Player(p));
        }
        return players;
    }

    public static List<Player> getPlayers(MinecraftServer server) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (net.minecraft.world.entity.player.Player p : server.getPlayerList().getPlayers()) {
            players.add(new Player(p));
        }
        return players;
    }

    public static Player getPlayerByUUID(Level world, UUID uuid) {
        return PlayerUtil.getPlayerByUUID(world.getServer(), uuid);
    }

    public static Player getPlayerByName(Level world, String name) {
        return PlayerUtil.getPlayerByName(world.getServer(), name);
    }

    public static boolean isExistByUUID(MinecraftServer server, UUID uuid) {
        return server.getPlayerList().getPlayer(uuid) != null;
    }

    public static boolean isExistByUUID(Level world, UUID uuid) {
        return PlayerUtil.isExistByUUID(world.getServer(), uuid);
    }

    public static boolean isExistByName(MinecraftServer server, String name) {
        return server.getPlayerList().getPlayerByName(name) != null;
    }

    public static boolean isExistByName(Level world, String name) {
        return PlayerUtil.isExistByName(world.getServer(), name);
    }

    public static boolean isExistByIP(MinecraftServer server, String ip) {
        return !server.getPlayerList().getPlayersWithAddress(ip).isEmpty();
    }

    public static boolean isExistByIP(Level world, String ip) {
        return PlayerUtil.isExistByIP(world.getServer(), ip);
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage((Component)TextUtil.literal(message));
    }

    public static float getYaw(Player player) {
        return player.getYaw();
    }

    public static float getPitch(Player player) {
        return player.getPitch();
    }

    public static BlockPos getBlockPos(Player player) {
        return player.getBlockPos();
    }

    public static Level getWorld(Player player) {
        return player.getWorld();
    }

    public static boolean isClient(Player player) {
        return player.isClient();
    }

    public static void teleport(Player player, double x, double y, double z) {
        player.teleport(x, y, z);
    }
}

