/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.enchantment.CompatEnchantment;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import org.jetbrains.annotations.Nullable;

public class EnchantmentUtil {
    public static CompatEnchantment getEnchantment(ResourceLocation identifier) {
        return new CompatEnchantment((Enchantment)BuiltInRegistries.ENCHANTMENT.get(identifier));
    }

    public static ResourceLocation getId(CompatEnchantment enchantment) {
        return enchantment.getId();
    }

    public static int getLevel(CompatEnchantment enchantment, ItemStack stack, @Nullable Level world) {
        return enchantment.getLevel(stack, world);
    }

    public static CompatEnchantment getEnchantment(CompatIdentifier identifier) {
        return EnchantmentUtil.getEnchantment(identifier.toMinecraft());
    }

    public static CompatIdentifier getCompatId(CompatEnchantment enchantment) {
        return CompatIdentifier.fromMinecraft(enchantment.getId());
    }

    public static List<CompatEnchantment> getEnchantments(ItemStack stack) {
        ArrayList<CompatEnchantment> enchantments = new ArrayList<CompatEnchantment>();
        EnchantmentHelper.getEnchantments((ItemStack)stack).forEach((key, value) -> enchantments.add(new CompatEnchantment((Enchantment)key)));
        return enchantments;
    }

    public static boolean hasEnchantment(ItemStack stack) {
        return stack.isEnchanted();
    }

    public static Map<CompatEnchantment, Integer> getEnchantment(ItemStack stack, @Nullable Level world) {
        HashMap<CompatEnchantment, Integer> enchantments = new HashMap<CompatEnchantment, Integer>();
        List<CompatEnchantment> enchantmentList = EnchantmentUtil.getEnchantments(stack);
        enchantmentList.forEach(enchantment -> enchantments.put((CompatEnchantment)enchantment, EnchantmentUtil.getLevel(enchantment, stack, world)));
        return enchantments;
    }

    public static void setEnchantment(ItemStack stack, Map<CompatEnchantment, Integer> enchantments, @Nullable Level world) {
        HashMap enchantmentMap = new HashMap();
        enchantments.forEach((key, value) -> enchantmentMap.put(key.getEnchantment(world), value));
        EnchantmentHelper.setEnchantments(enchantmentMap, (ItemStack)stack);
    }

    public static void removeEnchantment(ItemStack stack) {
        if (!stack.hasTag()) {
            return;
        }
        CompoundTag nbt = stack.getTag();
        if (nbt.contains("enchantments")) {
            stack.removeTagKey("enchantments");
        }
        if (nbt.contains("stored_enchantments")) {
            stack.removeTagKey("stored_enchantments");
        }
        if (nbt.contains("Enchantments")) {
            stack.removeTagKey("Enchantments");
        }
        if (nbt.contains("StoredEnchantments")) {
            stack.removeTagKey("StoredEnchantments");
        }
    }
}

