/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.math.random.CompatRandom;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.entity.EntityTypeWrapper;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.mcpitanlib.midohra.world.chunk.ChunkTicketType;
import org.jetbrains.annotations.Nullable;

public class WorldUtil {
    public static boolean hasSkyLight(Level world) {
        return world.dimensionType().hasSkyLight();
    }

    public static boolean isThundering(Level world) {
        return world.isThundering();
    }

    public static boolean isRaining(Level world) {
        return world.isRaining();
    }

    public static boolean isNight(Level world) {
        return world.isNight();
    }

    public static boolean isDay(Level world) {
        return world.isDay();
    }

    public static boolean isSkyVisible(Level world, BlockPos pos) {
        return world.canSeeSky(pos);
    }

    public static boolean isClient(Level world) {
        return world.isClientSide();
    }

    public static void scheduleBlockTick(Level world, BlockPos pos, Block block, int delay) {
        world.scheduleTick(pos, block, delay);
    }

    public static void scheduleFluidTick(Level world, BlockPos pos, Fluid fluid, int delay) {
        world.scheduleTick(pos, fluid, delay);
    }

    public static boolean isServer(Level world) {
        return !WorldUtil.isClient(world);
    }

    public static void spawnStack(Level world, BlockPos pos, ItemStack stack) {
        WorldUtil.spawnEntity(world, (Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
    }

    public static void spawnExperienceOrb(Level world, Vec3 pos, int amount) {
        if (world instanceof ServerLevel) {
            ExperienceOrb.award((ServerLevel)((ServerLevel)world), (Vec3)pos, (int)amount);
        }
    }

    public static void spawnExperienceOrb(Level world, BlockPos pos, int amount) {
        WorldUtil.spawnExperienceOrb(world, pos.getCenter(), amount);
    }

    public static void spawnEntity(Level world, Entity entity) {
        world.addFreshEntity(entity);
    }

    public static void playSound(Level world, @Nullable net.pitan76.mcpitanlib.api.entity.Player player, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        Player entity = player == null ? null : player.getEntity();
        world.playSound(entity, pos, sound, category, volume, pitch);
    }

    public static void playSound(Level world, @Nullable net.pitan76.mcpitanlib.api.entity.Player player, BlockPos pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world, player, pos, sound.get(), category.get(), volume, pitch);
    }

    public static void playSound(Level world, BlockPos pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world, null, pos, sound.get(), category.get(), volume, pitch);
    }

    public static void playSound(Level world, double x, double y, double z, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch, boolean useDistance) {
        world.playLocalSound(x, y, z, sound.get(), category.get(), volume, pitch, useDistance);
    }

    public static void sendEntityStatus(Level world, Entity entity, byte status) {
        world.broadcastEntityEvent(entity, status);
    }

    public static BlockPos getSpawnPos(Level world) {
        return world.getSharedSpawnPos();
    }

    public static Optional<MinecraftServer> getServer(Level world) {
        if (WorldUtil.isClient(world)) {
            return Optional.empty();
        }
        return Optional.ofNullable(world.getServer());
    }

    public static ServerLevel getWorld(Level world, ResourceLocation worldId) {
        Optional<MinecraftServer> server = WorldUtil.getServer(world);
        if (!server.isPresent()) {
            return null;
        }
        return WorldUtil.getWorld(server.get(), worldId);
    }

    public static Optional<ServerLevel> getWorld(Level world, CompatIdentifier worldId) {
        return Optional.ofNullable(WorldUtil.getWorld(world, worldId.toMinecraft()));
    }

    public static ServerLevel getOverworld(MinecraftServer server) {
        return server.getLevel(Level.OVERWORLD);
    }

    public static ServerLevel getNether(MinecraftServer server) {
        return server.getLevel(Level.NETHER);
    }

    public static ServerLevel getEnd(MinecraftServer server) {
        return server.getLevel(Level.END);
    }

    public static ServerLevel getWorld(MinecraftServer server, ResourceLocation worldId) {
        return server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)worldId));
    }

    public static ServerLevel getWorld(MinecraftServer server, CompatIdentifier worldId) {
        return WorldUtil.getWorld(server, worldId.toMinecraft());
    }

    public static ResourceLocation getWorldId(Level world) {
        return world.dimension().location();
    }

    public static CompatIdentifier getCompatWorldId(Level world) {
        return CompatIdentifier.fromMinecraft(WorldUtil.getWorldId(world));
    }

    public static boolean equals(Level world, Level world2) {
        return Objects.equals(WorldUtil.getWorldId(world), WorldUtil.getWorldId(world2));
    }

    @Deprecated
    public static <T> void addTicket(ServerLevel world, TicketType<T> type, ChunkPos pos, int radius, T argument) {
        world.getChunkSource().addRegionTicket(type, pos, radius, argument);
    }

    @Deprecated
    public static <T> void removeTicket(ServerLevel world, TicketType<T> type, ChunkPos pos, int radius, T argument) {
        world.getChunkSource().removeRegionTicket(type, pos, radius, argument);
    }

    public static <T> void addTicket(ServerLevel world, ChunkTicketType<T> type, ChunkPos pos, int radius, T argument) {
        WorldUtil.addTicket(world, type.getRaw(), pos, radius, argument);
    }

    public static <T> void removeTicket(ServerLevel world, ChunkTicketType<T> type, ChunkPos pos, int radius, T argument) {
        WorldUtil.removeTicket(world, type.getRaw(), pos, radius, argument);
    }

    public static void addTicket(ServerLevel world, ChunkTicketType<?> type, ChunkPos pos, int radius) {
        TicketType<?> rawType = type.getRaw();
        world.getChunkSource().addRegionTicket(rawType, pos, radius, (Object)pos);
    }

    public static void removeTicket(ServerLevel world, ChunkTicketType<?> type, ChunkPos pos, int radius) {
        TicketType<?> rawType = type.getRaw();
        world.getChunkSource().removeRegionTicket(rawType, pos, radius, (Object)pos);
    }

    public static boolean isReceivingRedstonePower(Level world, BlockPos pos) {
        return world.hasNeighborSignal(pos);
    }

    public static int getBottomY(Level world) {
        return world.getMinBuildHeight();
    }

    public static int getTopY(Level world) {
        return world.getMaxBuildHeight();
    }

    public static int getDimensionHeight(Level world) {
        return world.dimensionType().height();
    }

    public static BlockEntity getBlockEntity(Level world, BlockPos pos) {
        return world.getBlockEntity(pos);
    }

    public static boolean hasBlockEntity(Level world, BlockPos pos) {
        return WorldUtil.getBlockEntity(world, pos) != null;
    }

    public static BlockState getBlockState(Level world, BlockPos pos) {
        return world.getBlockState(pos);
    }

    public static FluidState getFluidState(Level world, BlockPos pos) {
        return world.getFluidState(pos);
    }

    public static boolean hasFluidState(Level world, BlockPos pos) {
        return !WorldUtil.getFluidState(world, pos).isEmpty();
    }

    public static boolean isAir(Level world, BlockPos pos) {
        return WorldUtil.getBlockState(world, pos).isAir();
    }

    public static boolean setBlockState(Level world, BlockPos pos, BlockState state, int flags) {
        return world.setBlock(pos, state, flags);
    }

    public static boolean setBlockState(Level world, BlockPos pos, BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(Level world, BlockPos pos, Block block, int flags) {
        return WorldUtil.setBlockState(world, pos, block.defaultBlockState(), flags);
    }

    public static boolean setBlockState(Level world, BlockPos pos, Block block) {
        return WorldUtil.setBlockState(world, pos, block, 3);
    }

    public static boolean breakBlock(Level world, BlockPos pos, boolean drop) {
        return world.destroyBlock(pos, drop);
    }

    public static boolean breakBlock(Level world, BlockPos pos) {
        return WorldUtil.breakBlock(world, pos, true);
    }

    public static boolean breakBlock(Level world, BlockPos pos, boolean drop, @Nullable net.pitan76.mcpitanlib.api.entity.Player player) {
        if (player == null) {
            return world.destroyBlock(pos, drop, null);
        }
        return world.destroyBlock(pos, drop, (Entity)player.getPlayerEntity());
    }

    public static boolean breakBlock(Level world, BlockPos pos, @Nullable net.pitan76.mcpitanlib.api.entity.Player player) {
        return WorldUtil.breakBlock(world, pos, true, player);
    }

    public static void removeBlockEntity(Level world, BlockPos pos) {
        world.removeBlockEntity(pos);
    }

    public static boolean removeBlock(Level world, BlockPos pos, boolean move) {
        return world.removeBlock(pos, move);
    }

    public static void addParticle(Level world, ParticleOptions parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        world.addParticle(parameters, x, y, z, velocityX, velocityY, velocityZ);
    }

    public static boolean canSetBlock(Level world, BlockPos pos) {
        return world.isLoaded(pos);
    }

    public static void updateComparators(Level world, BlockPos pos, Block block) {
        world.updateNeighbourForOutputSignal(pos, block);
    }

    public static List<net.pitan76.mcpitanlib.api.entity.Player> getPlayers(Level world) {
        ArrayList<net.pitan76.mcpitanlib.api.entity.Player> players = new ArrayList<net.pitan76.mcpitanlib.api.entity.Player>();
        for (Player player : world.players()) {
            players.add(new net.pitan76.mcpitanlib.api.entity.Player(player));
        }
        return players;
    }

    public static net.pitan76.mcpitanlib.api.entity.Player getPlayer(Level world, UUID uuid) {
        return new net.pitan76.mcpitanlib.api.entity.Player(world.getPlayerByUUID(uuid));
    }

    public static CompatRandom getRandom(Level world) {
        return new CompatRandom(world.getRandom());
    }

    public static long getTime(Level world) {
        return world.getGameTime();
    }

    public static <T extends Entity> List<T> getEntitiesByType(Level world, EntityType<T> filter, AABB box, Predicate<? super T> predicate) {
        return world.getEntities(filter, box, predicate);
    }

    public static <T extends Entity> List<T> getEntitiesByClass(Level world, Class<T> entityClass, AABB box, Predicate<? super T> predicate) {
        return world.getEntitiesOfClass(entityClass, box, predicate);
    }

    public static void spawnParticles(Level world, ParticleOptions parameters, double x, double y, double z, int count, double velocityX, double velocityY, double velocityZ, double speed) {
        if (!WorldUtil.isServer(world)) {
            return;
        }
        ((ServerLevel)world).sendParticles(parameters, x, y, z, count, velocityX, velocityY, velocityZ, speed);
    }

    public static void updateListeners(Level world, BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        world.sendBlockUpdated(pos, oldState, newState, flags);
    }

    public static net.pitan76.mcpitanlib.midohra.block.BlockState getMidohraBlockState(Level world, BlockPos pos) {
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(WorldUtil.getBlockState(world, pos));
    }

    public static boolean setBlockState(Level world, BlockPos pos, net.pitan76.mcpitanlib.midohra.block.BlockState state, int flags) {
        return WorldUtil.setBlockState(world, pos, state.toMinecraft(), flags);
    }

    public static boolean setBlockState(Level world, BlockPos pos, net.pitan76.mcpitanlib.midohra.block.BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, net.pitan76.mcpitanlib.midohra.block.BlockState state, int flags) {
        return WorldUtil.setBlockState(world, pos.toMinecraft(), state.toMinecraft(), flags);
    }

    public static boolean setBlockState(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, net.pitan76.mcpitanlib.midohra.block.BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean breakBlock(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean drop) {
        return WorldUtil.breakBlock(world, pos.toMinecraft(), drop);
    }

    public static boolean breakBlock(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return WorldUtil.breakBlock(world, pos, true);
    }

    public static boolean breakBlock(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean drop, @Nullable net.pitan76.mcpitanlib.api.entity.Player player) {
        return WorldUtil.breakBlock(world, pos.toMinecraft(), drop, player);
    }

    public static boolean breakBlock(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, @Nullable net.pitan76.mcpitanlib.api.entity.Player player) {
        return WorldUtil.breakBlock(world, pos, true, player);
    }

    public static void removeBlockEntity(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        WorldUtil.removeBlockEntity(world, pos.toMinecraft());
    }

    public static boolean removeBlock(Level world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, boolean move) {
        return WorldUtil.removeBlock(world, pos.toMinecraft(), move);
    }

    public static void playSound(World world, @Nullable net.pitan76.mcpitanlib.api.entity.Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world.getRaw(), player, pos.toMinecraft(), sound, category, volume, pitch);
    }

    public static void dropStackOnBlock(Level world, BlockPos pos, ItemStack stack) {
        Block.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
    }

    public static float getSkyAngle(Level world, float tickDelta) {
        return world.getTimeOfDay(tickDelta);
    }

    public static Block getBlock(Level world, BlockPos pos) {
        return WorldUtil.getBlockState(world, pos).getBlock();
    }

    public static BlockWrapper getBlockWrapper(Level world, BlockPos pos) {
        return BlockWrapper.of(WorldUtil.getBlock(world, pos));
    }

    public static <T extends Entity> List<T> getEntitiesByType(Level world, EntityType<T> filter, AABB box) {
        return WorldUtil.getEntitiesByType(world, filter, box, EntitySelector.ENTITY_STILL_ALIVE);
    }

    public static <T extends Entity> List<T> getEntitiesByType(Level world, EntityTypeWrapper filter, AABB box, Predicate<? super T> predicate) {
        return WorldUtil.getEntitiesByType(world, filter.get(), box, predicate);
    }

    public static List<?> getEntitiesByType(Level world, EntityTypeWrapper filter, AABB box) {
        return WorldUtil.getEntitiesByType(world, filter.get(), box);
    }
}

