/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.pitan76.mcpitanlib.api.client.render.DrawObjectMV;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class VertexConsumerUtil {
    public static VertexConsumer vertex(VertexConsumer vertexConsumer, float x, float y, float z) {
        return vertexConsumer.vertex((double)x, (double)y, (double)z);
    }

    public static VertexConsumer vertex(VertexConsumer vertexConsumer, PoseStack stack, float x, float y, float z) {
        return vertexConsumer.vertex(stack.last().pose(), x, y, z);
    }

    public static VertexConsumer normal(VertexConsumer vertexConsumer, float x, float y, float z) {
        return vertexConsumer.normal(x, y, z);
    }

    public static VertexConsumer color(VertexConsumer vertexConsumer, float red, float green, float blue, float alpha) {
        return vertexConsumer.color(red, green, blue, alpha);
    }

    public static VertexConsumer color(VertexConsumer vertexConsumer, int red, int green, int blue, int alpha) {
        return vertexConsumer.color(red, green, blue, alpha);
    }

    public static VertexConsumer colorARGB(VertexConsumer vertexConsumer, int argb) {
        return vertexConsumer.color(argb);
    }

    public static VertexConsumer colorRGB(VertexConsumer vertexConsumer, int rgb) {
        int argb = rgb & 0xFF0000 | (rgb & 0xFF00) >> 8 | (rgb & 0xFF) << 8 | rgb & 0xFF000000;
        return VertexConsumerUtil.colorARGB(vertexConsumer, argb);
    }

    public static VertexConsumer light(VertexConsumer vertexConsumer, int light) {
        return vertexConsumer.uv2(light);
    }

    public static VertexConsumer overlay(VertexConsumer vertexConsumer, int overlay) {
        return vertexConsumer.overlayCoords(overlay);
    }

    public static VertexConsumer overlayDefaultUV(VertexConsumer vertexConsumer) {
        return vertexConsumer.overlayCoords(OverlayTexture.NO_OVERLAY);
    }

    public static DrawObjectMV vertex(DrawObjectMV drawObject, float x, float y, float z) {
        VertexConsumerUtil.vertex(drawObject.getBuffer(), drawObject.getStack(), x, y, z);
        return drawObject;
    }

    public static DrawObjectMV normal(DrawObjectMV drawObject, float x, float y, float z) {
        VertexConsumerUtil.normal(drawObject.getBuffer(), x, y, z);
        return drawObject;
    }

    public static DrawObjectMV color(DrawObjectMV drawObject, float red, float green, float blue, float alpha) {
        VertexConsumerUtil.color(drawObject.getBuffer(), red, green, blue, alpha);
        return drawObject;
    }

    public static DrawObjectMV color(DrawObjectMV drawObject, int red, int green, int blue, int alpha) {
        VertexConsumerUtil.color(drawObject.getBuffer(), red, green, blue, alpha);
        return drawObject;
    }

    public static DrawObjectMV colorARGB(DrawObjectMV drawObject, int argb) {
        VertexConsumerUtil.colorARGB(drawObject.getBuffer(), argb);
        return drawObject;
    }

    public static DrawObjectMV colorRGB(DrawObjectMV drawObject, int rgb) {
        VertexConsumerUtil.colorRGB(drawObject.getBuffer(), rgb);
        return drawObject;
    }

    public static DrawObjectMV light(DrawObjectMV drawObject, int light) {
        VertexConsumerUtil.light(drawObject.getBuffer(), light);
        return drawObject;
    }

    public static DrawObjectMV overlay(DrawObjectMV drawObject, int overlay) {
        VertexConsumerUtil.overlay(drawObject.getBuffer(), overlay);
        return drawObject;
    }

    public static DrawObjectMV overlayDefaultUV(DrawObjectMV drawObject) {
        VertexConsumerUtil.overlayDefaultUV(drawObject.getBuffer());
        return drawObject;
    }

    public static VertexConsumer texture(VertexConsumer vertexConsumer, float u, float v) {
        return vertexConsumer.uv(u, v);
    }

    public static VertexConsumer vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, float x, float y, float z) {
        return vertexConsumer.vertex(matrix4f, x, y, z);
    }

    public static VertexConsumer normal(VertexConsumer vertexConsumer, PoseStack stack, float x, float y, float z) {
        return vertexConsumer.normal(stack.last().normal(), x, y, z);
    }

    public static VertexConsumer next(VertexConsumer vertexConsumer) {
        vertexConsumer.endVertex();
        return vertexConsumer;
    }

    public static void renderQuad(VertexConsumer vertexConsumer, PoseStack stack, Matrix4f matrix4f, Matrix3f matrix3f, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ, int r, int g, int b, int alpha, int u, int v, int overlay, int light) {
        Object vertexes = new float[4][3];
        if (Math.abs(normalY) > 0.5f) {
            vertexes = normalY > 0.0f ? (Object)new float[][]{{x1, y1, z1}, {x1, y1, z2}, {x2, y1, z2}, {x2, y1, z1}} : (Object)new float[][]{{x1, y1, z1}, {x2, y1, z1}, {x2, y1, z2}, {x1, y1, z2}};
        } else if (Math.abs(normalZ) > 0.5f) {
            vertexes = normalZ > 0.0f ? (Object)new float[][]{{x1, y1, z1}, {x2, y1, z1}, {x2, y2, z1}, {x1, y2, z1}} : (Object)new float[][]{{x1, y1, z1}, {x1, y2, z1}, {x2, y2, z1}, {x2, y1, z1}};
        } else if (Math.abs(normalX) > 0.5f) {
            vertexes = normalX > 0.0f ? (Object)new float[][]{{x1, y1, z1}, {x1, y2, z1}, {x1, y2, z2}, {x1, y1, z2}} : (Object)new float[][]{{x1, y1, z1}, {x1, y1, z2}, {x1, y2, z2}, {x1, y2, z1}};
        }
        for (float[] vertex : vertexes) {
            if (vertex.length != 3) continue;
            VertexConsumerUtil.vertex(vertexConsumer, matrix4f, vertex[0], vertex[1], vertex[2]);
            VertexConsumerUtil.color(vertexConsumer, r, g, b, alpha);
            VertexConsumerUtil.texture(vertexConsumer, u, v);
            VertexConsumerUtil.light(vertexConsumer, light);
            VertexConsumerUtil.normal(vertexConsumer, stack, normalX, normalY, normalZ);
            VertexConsumerUtil.next(vertexConsumer);
        }
    }

    public static void renderQuad(DrawObjectMV drawObject, Matrix4f matrix4f, Matrix3f matrix3f, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ, int r, int g, int b, int alpha, int u, int v, int overlay, int light) {
        VertexConsumerUtil.renderQuad(drawObject.getBuffer(), drawObject.getStack(), matrix4f, matrix3f, x1, y1, z1, x2, y2, z2, normalX, normalY, normalZ, r, g, b, alpha, u, v, overlay, light);
    }

    public static void renderQuad(DrawObjectMV drawObject, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ, int r, int g, int b, int alpha, int u, int v, int overlay, int light) {
        Matrix4f matrix4f = drawObject.getMatrix4f();
        Matrix3f matrix3f = drawObject.getMatrix3f();
        VertexConsumerUtil.renderQuad(drawObject.getBuffer(), drawObject.getStack(), matrix4f, matrix3f, x1, y1, z1, x2, y2, z2, normalX, normalY, normalZ, r, g, b, alpha, u, v, overlay, light);
    }
}

