/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.color;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.client.color.forge.BlockColorEventImpl;
import net.pitan76.mcpitanlib.midohra.world.BlockView;
import org.jetbrains.annotations.Nullable;

public class BlockColorEvent {
    private final BlockState state;
    private final BlockAndTintGetter world;
    private final BlockPos pos;
    private final int tintIndex;

    public BlockColorEvent(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.tintIndex = tintIndex;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockAndTintGetter getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getTintIndex() {
        return this.tintIndex;
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getPos());
    }

    public net.pitan76.mcpitanlib.midohra.block.BlockState getMidohraState() {
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(this.getState());
    }

    public boolean hasWorld() {
        return this.getWorld() != null;
    }

    public boolean hasPos() {
        return this.getPos() != null;
    }

    public BlockView getMidohraWorld() {
        if (!this.hasWorld()) {
            return null;
        }
        return BlockView.of((BlockGetter)this.getWorld());
    }

    public BlockEntity getBlockEntity() {
        if (!this.hasWorld() || !this.hasPos()) {
            return null;
        }
        return this.getWorld().m_7702_(this.getPos());
    }

    public int getDefaultColor() {
        return 0xFFFFFF;
    }

    public Object getRenderData() {
        if (!this.hasWorld() || !this.hasPos()) {
            return null;
        }
        return BlockColorEvent.getRenderDataD(this.getBlockEntity());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static Object getRenderDataD(BlockEntity blockEntity) {
        return BlockColorEventImpl.getRenderDataD((BlockEntity)blockEntity);
    }
}

