/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.item;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.item.ItemUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemWrapper {
    private final Item item;

    protected ItemWrapper() {
        this.item = null;
    }

    protected ItemWrapper(Item item) {
        this.item = item;
    }

    public static ItemWrapper of(Item item) {
        return new ItemWrapper(item);
    }

    public static ItemWrapper of() {
        return new ItemWrapper();
    }

    public static ItemWrapper of(CompatIdentifier id) {
        if (ItemUtil.isExist(id)) {
            return ItemWrapper.of(ItemUtil.fromId(id));
        }
        return ItemWrapper.of();
    }

    public static ItemWrapper of(CompatIdentifier id, CompatIdentifier ... ids) {
        if (ItemWrapper.of(id).isPresent()) {
            return ItemWrapper.of(id);
        }
        for (CompatIdentifier id1 : ids) {
            if (!ItemWrapper.of(id1).isPresent()) continue;
            return ItemWrapper.of(id1);
        }
        return ItemWrapper.of();
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    public boolean isAir() {
        return this.isEmpty() || this.get() == Items.f_41852_;
    }

    @Nullable
    public Item get() {
        return this.item;
    }

    public Item gerOrDefault(Item defaultItem) {
        return this.isEmpty() ? defaultItem : this.get();
    }

    public CompatIdentifier getId() {
        if (this.isEmpty()) {
            return CompatIdentifier.empty();
        }
        return ItemUtil.toId(this.get());
    }

    public String getName() {
        if (this.isEmpty()) {
            return "";
        }
        return ItemUtil.getNameAsString(this.get());
    }

    public String getTranslationKey() {
        if (this.isEmpty()) {
            return "";
        }
        return ItemUtil.getTranslationKey(this.get());
    }

    public ItemStack createStack(int count) {
        if (this.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ItemStack.of(ItemStackUtil.create(this.get(), count));
    }

    public ItemStack createStack() {
        return this.createStack(1);
    }

    public boolean isInTag(CompatIdentifier id) {
        return ItemUtil.isInTag(this.get(), id);
    }

    public boolean isBlock() {
        return !this.isEmpty() && this.get() instanceof BlockItem;
    }

    public BlockWrapper asBlock() {
        if (!this.isBlock()) {
            return BlockWrapper.of();
        }
        return BlockWrapper.of(((BlockItem)this.get()).m_40614_());
    }

    public boolean rawEquals(ItemWrapper item) {
        return this.get() == item.get();
    }
}

