/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.server;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserWhiteList;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.World;

public class PlayerManager {
    private final PlayerList playerManager;

    protected PlayerManager(PlayerList playerManager) {
        this.playerManager = playerManager;
    }

    public static PlayerManager of(PlayerList playerManager) {
        return new PlayerManager(playerManager);
    }

    public static PlayerManager of(MinecraftServer server) {
        return PlayerManager.of(server.m_6846_());
    }

    public static PlayerManager of(MCServer server) {
        return PlayerManager.of(server.getRaw());
    }

    public static PlayerManager of(ServerWorld world) {
        return PlayerManager.of(world.getServer());
    }

    public static PlayerManager of(World world) {
        return PlayerManager.of(world.getServer());
    }

    public PlayerList getRaw() {
        return this.playerManager;
    }

    public PlayerList toMinecraft() {
        return this.getRaw();
    }

    public void broadcast(TextComponent message, boolean overlay) {
        this.getRaw().m_240416_(message.getText(), overlay);
    }

    public void broadcast(TextComponent message) {
        this.broadcast(message, false);
    }

    public void broadcast(String message, boolean overlay) {
        this.getRaw().m_240416_((Component)TextUtil.literal(message), overlay);
    }

    public void broadcast(String message) {
        this.broadcast(message, false);
    }

    public void removePlayer(Player player) {
        this.getRaw().m_11286_(player.getServerPlayer().get());
    }

    public Player getPlayerByUUID(UUID uuid) {
        return new Player((net.minecraft.world.entity.player.Player)this.getRaw().m_11259_(uuid));
    }

    public Player getPlayerByName(String name) {
        return new Player((net.minecraft.world.entity.player.Player)this.getRaw().m_11255_(name));
    }

    public List<Player> getPlayersByIP(String ip) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (net.minecraft.world.entity.player.Player p : this.getRaw().m_11282_(ip)) {
            players.add(new Player(p));
        }
        return players;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (net.minecraft.world.entity.player.Player p : this.getRaw().m_11314_()) {
            players.add(new Player(p));
        }
        return players;
    }

    public boolean isExistByUUID(UUID uuid) {
        return this.getRaw().m_11259_(uuid) != null;
    }

    public boolean isExistByName(String name) {
        return this.getRaw().m_11255_(name) != null;
    }

    public boolean isExistByIP(String ip) {
        return !this.getRaw().m_11282_(ip).isEmpty();
    }

    public boolean hasPlayerByUUID(UUID uuid) {
        return this.getRaw().m_11259_(uuid) != null;
    }

    public boolean hasPlayerByName(String name) {
        return this.getRaw().m_11255_(name) != null;
    }

    public boolean hasPlayerByIP(String ip) {
        return !this.getRaw().m_11282_(ip).isEmpty();
    }

    public int getCurrentPlayerCount() {
        return this.getRaw().m_11309_();
    }

    public int getMaxPlayerCount() {
        return this.getRaw().m_11310_();
    }

    public boolean isWhitelistEnabled() {
        return this.getRaw().m_11311_();
    }

    public void setWhitelistEnabled(boolean enabled) {
        this.getRaw().m_6628_(enabled);
    }

    public UserWhiteList getWhitelist() {
        return this.getRaw().m_11305_();
    }

    public void reloadWhitelist() {
        this.getRaw().m_7542_();
    }

    public IpBanList getBannedIpList() {
        return this.getRaw().m_11299_();
    }

    public UserBanList getBannedPlayerList() {
        return this.getRaw().m_11295_();
    }
}

