/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;

public class ItemUseEvent
extends BaseEvent {
    public Level world;
    public Player user;
    public InteractionHand hand;
    public net.minecraft.world.item.ItemStack stack;

    public ItemUseEvent(Level world, net.minecraft.world.entity.player.Player user, InteractionHand hand) {
        this.world = world;
        this.user = new Player(user);
        this.hand = hand;
        this.stack = user.getItemInHand(hand);
    }

    public net.minecraft.world.item.ItemStack getStack() {
        return this.stack;
    }

    public ItemStack getMidohraStack() {
        return ItemStack.of(this.stack);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public Level getWorld() {
        return this.world;
    }

    public Player getUser() {
        return this.user;
    }

    public boolean isClient() {
        return this.world.isClientSide();
    }

    public StackActionResult success(net.minecraft.world.item.ItemStack stack) {
        if (this.getStack() != stack) {
            StackActionResult.success(stack);
        }
        return this.success();
    }

    public StackActionResult success(ItemStack stack) {
        return this.success(stack.toMinecraft());
    }

    public StackActionResult success() {
        return StackActionResult.create(CompatActionResult.SUCCESS);
    }

    public StackActionResult fail() {
        return StackActionResult.fail();
    }

    public StackActionResult fail(ItemStack stack) {
        return StackActionResult.fail(stack.toMinecraft());
    }

    public StackActionResult pass() {
        return StackActionResult.pass();
    }

    public StackActionResult pass(ItemStack stack) {
        return StackActionResult.pass(stack.toMinecraft());
    }

    public StackActionResult consume(net.minecraft.world.item.ItemStack stack) {
        if (this.getStack() != stack) {
            StackActionResult.consume(stack);
        }
        return this.consume();
    }

    public CompatActionResult consume(ItemStack stack) {
        return this.consume(stack.toMinecraft());
    }

    public StackActionResult consume() {
        return StackActionResult.create(CompatActionResult.CONSUME);
    }

    public boolean isSneaking() {
        return this.user.isSneaking();
    }

    public World getMidohraWorld() {
        return World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }
}

