/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.v2;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.event.item.CanRepairArgs;
import net.pitan76.mcpitanlib.api.event.item.EnchantabilityArgs;
import net.pitan76.mcpitanlib.api.event.item.EnchantableArgs;
import net.pitan76.mcpitanlib.api.event.item.InventoryTickEvent;
import net.pitan76.mcpitanlib.api.item.ExtendItem;
import net.pitan76.mcpitanlib.api.item.args.RarityArgs;
import net.pitan76.mcpitanlib.api.item.args.StoppedUsingArgs;
import net.pitan76.mcpitanlib.api.item.args.UseActionArgs;
import net.pitan76.mcpitanlib.api.item.consume.CompatUseAction;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.tag.item.RepairIngredientTag;
import net.pitan76.mcpitanlib.api.util.CompatRarity;
import net.pitan76.mcpitanlib.core.Dummy;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;

public class CompatItem
extends ExtendItem {
    public CompatibleItemSettings settings;

    public CompatItem(CompatibleItemSettings settings) {
        super(settings);
        this.settings = settings;
    }

    public CompatibleItemSettings getCompatSettings() {
        return this.settings;
    }

    public ItemWrapper getWrapper() {
        return ItemWrapper.of(this);
    }

    @Override
    @Deprecated
    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return this.getUseAction(new UseActionArgs(stack)).get();
    }

    public CompatUseAction getUseAction(UseActionArgs args) {
        return CompatUseAction.of(super.getUseAnimation(args.stack));
    }

    @Override
    @Deprecated
    public Rarity getRarity(ItemStack stack) {
        return this.getRarity(new RarityArgs(stack)).get();
    }

    public CompatRarity getRarity(RarityArgs args) {
        return this.settings.rarity;
    }

    @Override
    public boolean isEnchantable(EnchantableArgs args) {
        return this.settings.enchantability != -1;
    }

    @Override
    public int getEnchantability(EnchantabilityArgs args) {
        return this.settings.enchantability;
    }

    @Override
    public boolean canRepair(CanRepairArgs args) {
        RepairIngredientTag tag = this.settings.repairIngredientTag;
        return tag != null && tag.contains(args.stack);
    }

    @Override
    public boolean hasRecipeRemainder(Dummy dummy) {
        return this.settings.recipeRemainder != null;
    }

    @Deprecated
    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        return this.onStoppedUsing(new StoppedUsingArgs(stack, world, user, remainingUseTicks));
    }

    public boolean onStoppedUsing(StoppedUsingArgs args) {
        return super.releaseUsing(args.stack, args.world, args.user, args.remainingUseTicks);
    }

    @Deprecated
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.inventoryTick(new InventoryTickEvent(stack, world, entity, slot, selected));
    }

    public void inventoryTick(InventoryTickEvent e) {
        super.inventoryTick(e.stack, e.world, e.entity, e.slot, e.selected);
    }
}

