/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.v3;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.pitan76.mcpitanlib.api.item.v3.CompatToolMaterial;
import net.pitan76.mcpitanlib.api.tag.item.RepairIngredientTag;

public class VanillaCompatToolMaterial
implements CompatToolMaterial {
    private final ToolMaterial material;
    public static final VanillaCompatToolMaterial WOOD = VanillaCompatToolMaterial.of(ToolMaterial.WOOD);
    public static final VanillaCompatToolMaterial STONE = VanillaCompatToolMaterial.of(ToolMaterial.STONE);
    public static final VanillaCompatToolMaterial IRON = VanillaCompatToolMaterial.of(ToolMaterial.IRON);
    public static final VanillaCompatToolMaterial GOLD = VanillaCompatToolMaterial.of(ToolMaterial.GOLD);
    public static final VanillaCompatToolMaterial DIAMOND = VanillaCompatToolMaterial.of(ToolMaterial.DIAMOND);
    public static final VanillaCompatToolMaterial NETHERITE = VanillaCompatToolMaterial.of(ToolMaterial.NETHERITE);

    protected VanillaCompatToolMaterial(ToolMaterial material) {
        this.material = material;
    }

    private static VanillaCompatToolMaterial of(ToolMaterial material) {
        return new VanillaCompatToolMaterial(material);
    }

    @Override
    public RepairIngredientTag getRepairIngredientTag() {
        return new RepairIngredientTag((TagKey<Item>)this.material.repairItems());
    }

    @Override
    public int getCompatDurability() {
        return this.material.durability();
    }

    @Override
    public float getCompatMiningSpeedMultiplier() {
        return this.material.speed();
    }

    @Override
    public float getCompatAttackDamage() {
        return this.material.attackDamageBonus();
    }

    @Override
    public int getCompatMiningLevel() {
        TagKey tag = this.material.incorrectBlocksForDrops();
        if (tag == ToolMaterial.WOOD.incorrectBlocksForDrops()) {
            return 0;
        }
        if (tag == ToolMaterial.STONE.incorrectBlocksForDrops()) {
            return 1;
        }
        if (tag == ToolMaterial.IRON.incorrectBlocksForDrops()) {
            return 2;
        }
        if (tag == ToolMaterial.GOLD.incorrectBlocksForDrops()) {
            return 2;
        }
        if (tag == ToolMaterial.DIAMOND.incorrectBlocksForDrops()) {
            return 3;
        }
        if (tag == ToolMaterial.NETHERITE.incorrectBlocksForDrops()) {
            return 4;
        }
        return -1;
    }

    @Override
    public int getCompatEnchantability() {
        return this.material.enchantmentValue();
    }

    @Deprecated
    public ToolMaterial toMinecraft() {
        return this.material;
    }

    @Override
    public ToolMaterial build() {
        return this.material;
    }
}

