/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TextConverter {
    public static MutableComponent convert(String string) {
        return TextConverter.convert(string, false);
    }

    public static MutableComponent convert(String text, boolean translatable) {
        String[] splits = TextConverter.split(text);
        MutableComponent result = Component.literal((String)"");
        ChatFormatting[] currentFormatting = new ChatFormatting[]{};
        for (String part : splits) {
            if (part.startsWith("\u00a7") && part.length() == 2) {
                char code = part.charAt(1);
                if (code == 'r') {
                    currentFormatting = new ChatFormatting[]{};
                    continue;
                }
                ChatFormatting format = ChatFormatting.getByCode((char)code);
                if (format == null) continue;
                if (code >= 'k' && code <= 'o') {
                    ArrayList<ChatFormatting> list = new ArrayList<ChatFormatting>(Arrays.asList(currentFormatting));
                    list.add(format);
                    currentFormatting = list.toArray(new ChatFormatting[0]);
                    continue;
                }
                currentFormatting = new ChatFormatting[]{format};
                continue;
            }
            if (translatable) {
                Pattern pattern = Pattern.compile("\\{(.+?)\\}");
                Matcher matcher = pattern.matcher(part);
                MutableComponent tempText = Component.literal((String)"");
                int lastIndex = 0;
                while (matcher.find()) {
                    if (matcher.start() > lastIndex) {
                        tempText.append((Component)Component.literal((String)part.substring(lastIndex, matcher.start())).withStyle(currentFormatting));
                    }
                    String key = matcher.group(1);
                    tempText.append((Component)Component.translatable((String)key).withStyle(currentFormatting));
                    lastIndex = matcher.end();
                }
                if (lastIndex < part.length()) {
                    tempText.append((Component)Component.literal((String)part.substring(lastIndex)).withStyle(currentFormatting));
                }
                result.append((Component)tempText);
                continue;
            }
            result.append((Component)Component.literal((String)part).withStyle(currentFormatting));
        }
        return result;
    }

    public static String[] split(String text) {
        Matcher matcher = Pattern.compile("(?i)\u00a7[0-9a-fk-or]|[^\u00a7]+").matcher(text);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group());
        }
        return parts.toArray(new String[0]);
    }
}

