/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.transfer.fluid.v1;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.FluidStorageUtil;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.IFluidVariant;
import net.pitan76.mcpitanlib.midohra.fluid.FluidWrapper;

public interface IFluidStorage {
    public long getAmount();

    public long getCapacity();

    public IFluidVariant getResource();

    public void setResource(IFluidVariant var1);

    public long insert(IFluidVariant var1, long var2, boolean var4);

    public long extract(IFluidVariant var1, long var2, boolean var4);

    public void writeNbt(WriteNbtArgs var1);

    public void readNbt(WriteNbtArgs var1);

    default public long insert(IFluidVariant variant, long maxAmount) {
        return this.insert(variant, maxAmount, false);
    }

    default public long extract(IFluidVariant variant, long maxAmount) {
        return this.extract(variant, maxAmount, false);
    }

    default public long insert(Fluid fluid, long maxAmount) {
        return this.insert(FluidStorageUtil.getVariant(fluid), maxAmount);
    }

    default public long extract(Fluid fluid, long maxAmount) {
        return this.extract(FluidStorageUtil.getVariant(fluid), maxAmount);
    }

    default public long insert(FluidWrapper wrapper, long maxAmount) {
        return this.insert(wrapper.get(), maxAmount);
    }

    default public long extract(FluidWrapper wrapper, long maxAmount) {
        return this.extract(wrapper.get(), maxAmount);
    }

    default public boolean isResourceBlank() {
        return this.getResource() == null || this.getAmount() <= 0L;
    }

    default public boolean isResource(IFluidVariant variant) {
        return this.getResource() == variant;
    }

    default public boolean isEmpty() {
        return this.getAmount() <= 0L;
    }

    default public boolean isFull() {
        return this.getAmount() >= this.getCapacity();
    }

    default public boolean canInsert(IFluidVariant variant, long amount) {
        return this.insert(variant, amount, true) == amount;
    }

    default public boolean canExtract(IFluidVariant variant, long amount) {
        return this.extract(variant, amount, true) == amount;
    }

    default public boolean canInsert(Fluid fluid, long amount) {
        return this.canInsert(FluidStorageUtil.getVariant(fluid), amount);
    }

    default public boolean canExtract(Fluid fluid, long amount) {
        return this.canExtract(FluidStorageUtil.getVariant(fluid), amount);
    }

    default public boolean canInsert(FluidWrapper wrapper, long amount) {
        return this.canInsert(wrapper.get(), amount);
    }

    default public boolean canExtract(FluidWrapper wrapper, long amount) {
        return this.canExtract(wrapper.get(), amount);
    }

    default public void writeNbt(CompoundTag nbt, CompatRegistryLookup registryLookup) {
        this.writeNbt(new WriteNbtArgs(nbt, registryLookup));
    }

    default public void readNbt(CompoundTag nbt, CompatRegistryLookup registryLookup) {
        this.readNbt(new WriteNbtArgs(nbt, registryLookup));
    }
}

