/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;

public class IngredientUtil {
    public static Ingredient fromTagByIdentifier(ResourceLocation id) {
        List<Item> items = ItemUtil.getItems(id);
        ArrayList<Holder> entryList = new ArrayList<Holder>();
        for (Item item : items) {
            entryList.add(BuiltInRegistries.ITEM.wrapAsHolder((Object)item));
        }
        HolderSet.Direct entryList2 = HolderSet.direct(entryList);
        return Ingredient.of((HolderSet)entryList2);
    }

    public static Ingredient fromTagByString(String id) {
        return IngredientUtil.fromTagByIdentifier(IdentifierUtil.id(id));
    }

    public static Ingredient fromTagByIdentifier(CompatIdentifier id) {
        return IngredientUtil.fromTagByIdentifier(id.toMinecraft());
    }

    public static List<Item> getItems(Ingredient ingredient) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Holder entry : ingredient.items()) {
            items.add((Item)entry.value());
        }
        return items;
    }

    public static IntList getMatchingStacksIds(Ingredient ingredient) {
        IntArrayList ids = new IntArrayList();
        for (Item item : IngredientUtil.getItems(ingredient)) {
            ids.add(ItemUtil.getRawId(item));
        }
        return ids;
    }

    public static List<ItemStack> getMatchingStacksAsList(Ingredient ingredient) {
        return new ArrayList<ItemStack>(Arrays.asList(IngredientUtil.getMatchingStacks(ingredient)));
    }

    public static ItemStack[] getMatchingStacks(Ingredient ingredient) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : IngredientUtil.getItems(ingredient)) {
            stacks.add(new ItemStack((ItemLike)item));
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public static Ingredient empty() {
        return null;
    }

    public static Ingredient ofItems(ItemLike ... items) {
        return Ingredient.of((ItemLike[])items);
    }

    public static NonNullList<Ingredient> buildInput(Object[] input) {
        NonNullList list = NonNullList.create();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            if (!(obj instanceof ItemLike)) continue;
            list.add((Object)IngredientUtil.ofItems((ItemLike)obj));
        }
        return list;
    }
}

