/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.client;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.pitan76.mcpitanlib.api.util.client.ClientUtil;

public class LanguageUtil {
    public static boolean hasTranslation(String key) {
        return I18n.exists((String)key);
    }

    public static String translate(String key) {
        return I18n.get((String)key, (Object[])new Object[0]);
    }

    public static String translate(String key, Object ... args) {
        return I18n.get((String)key, (Object[])args);
    }

    public static String translateWithFallback(String key, String fallback) {
        return I18n.exists((String)key) ? I18n.get((String)key, (Object[])new Object[0]) : fallback;
    }

    public static String translateWithFallback(String key, String fallback, Object ... args) {
        return I18n.exists((String)key) ? I18n.get((String)key, (Object[])args) : fallback;
    }

    public static LanguageManager getLanguageManager() {
        return ClientUtil.getClient().getLanguageManager();
    }

    public static String getLanguage() {
        return LanguageUtil.getLanguageManager().getSelected();
    }

    public static void setLanguage(String language) {
        LanguageUtil.getLanguageManager().setSelected(language);
    }

    public static void reload(ResourceManager resourceManager) {
        LanguageUtil.getLanguageManager().onResourceManagerReload(resourceManager);
    }

    public static void reload(net.pitan76.mcpitanlib.midohra.resource.ResourceManager resourceManager) {
        LanguageUtil.reload(resourceManager.getRaw());
    }
}

