/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world.chunk;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;

public class ChunkTicketType<T> {
    public static final ChunkTicketType<Unit> START = ChunkTicketType.of(TicketType.START);
    public static final ChunkTicketType<Unit> DRAGON = ChunkTicketType.of(TicketType.DRAGON);
    public static final ChunkTicketType<ChunkPos> PLAYER = ChunkTicketType.of(TicketType.PLAYER);
    public static final ChunkTicketType<ChunkPos> FORCED = ChunkTicketType.of(TicketType.FORCED);
    public static final ChunkTicketType<BlockPos> PORTAL = ChunkTicketType.of(TicketType.PORTAL);
    public static final ChunkTicketType<ChunkPos> ENDER_PEARL = ChunkTicketType.of(TicketType.ENDER_PEARL);
    public static final ChunkTicketType<Integer> POST_TELEPORT = ChunkTicketType.of(TicketType.POST_TELEPORT);
    public static final ChunkTicketType<ChunkPos> UNKNOWN = ChunkTicketType.of(TicketType.UNKNOWN);
    private final TicketType<T> ticketType;

    protected ChunkTicketType(TicketType<T> ticketType) {
        this.ticketType = ticketType;
    }

    public static <T> ChunkTicketType<T> of(TicketType<T> ticketType) {
        return new ChunkTicketType<T>(ticketType);
    }

    public TicketType<T> getRaw() {
        return this.ticketType;
    }

    public TicketType<T> toMinecraft() {
        return this.getRaw();
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator) {
        return ChunkTicketType.of(TicketType.create((String)name, argumentComparator));
    }

    public static <T> ChunkTicketType<T> create(String name, Comparator<T> argumentComparator, int expiryTicks) {
        return ChunkTicketType.of(TicketType.create((String)name, argumentComparator, (int)expiryTicks));
    }

    public Comparator<T> getArgumentComparator() {
        return this.getRaw().getComparator();
    }

    public long getExpiryTicks() {
        return this.getRaw().timeout();
    }

    public String toString() {
        return this.getRaw().toString();
    }

    public ChunkTicketType(String name, long expiryTicks) {
        this(ChunkTicketType._of(name, expiryTicks));
    }

    public ChunkTicketType(String name) {
        this(name, 0L);
    }

    public static ChunkTicketType<ChunkPos> create(String name, long expiryTicks) {
        return new ChunkTicketType<ChunkPos>(name, expiryTicks);
    }

    public static ChunkTicketType<ChunkPos> create(String name) {
        return new ChunkTicketType<ChunkPos>(name);
    }

    private static <T> TicketType<T> _of(String name, long expiryTicks) {
        TicketType type = TicketType.create((String)name, Comparator.comparingLong(ChunkPos::toLong), (int)((int)expiryTicks));
        return type;
    }
}

