/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.math.random.CompatRandom;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.entity.EntityTypeWrapper;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.mcpitanlib.midohra.world.chunk.ChunkTicketType;
import org.jetbrains.annotations.Nullable;

public class WorldUtil {
    public static boolean hasSkyLight(class_1937 world) {
        return world.method_8597().comp_642();
    }

    public static boolean isThundering(class_1937 world) {
        return world.method_8546();
    }

    public static boolean isRaining(class_1937 world) {
        return world.method_8419();
    }

    public static boolean isNight(class_1937 world) {
        return world.method_23886();
    }

    public static boolean isDay(class_1937 world) {
        return world.method_8530();
    }

    public static boolean isSkyVisible(class_1937 world, class_2338 pos) {
        return world.method_8311(pos);
    }

    public static boolean isClient(class_1937 world) {
        return world.method_8608();
    }

    public static void scheduleBlockTick(class_1937 world, class_2338 pos, class_2248 block, int delay) {
        world.method_64310(pos, block, delay);
    }

    public static void scheduleFluidTick(class_1937 world, class_2338 pos, class_3611 fluid, int delay) {
        world.method_64312(pos, fluid, delay);
    }

    public static boolean isServer(class_1937 world) {
        return !WorldUtil.isClient(world);
    }

    public static void spawnStack(class_1937 world, class_2338 pos, class_1799 stack) {
        WorldUtil.spawnEntity(world, (class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack));
    }

    public static void spawnExperienceOrb(class_1937 world, class_243 pos, int amount) {
        if (world instanceof class_3218) {
            class_1303.method_31493((class_3218)((class_3218)world), (class_243)pos, (int)amount);
        }
    }

    public static void spawnExperienceOrb(class_1937 world, class_2338 pos, int amount) {
        WorldUtil.spawnExperienceOrb(world, pos.method_46558(), amount);
    }

    public static void spawnEntity(class_1937 world, class_1297 entity) {
        world.method_8649(entity);
    }

    public static void playSound(class_1937 world, @Nullable Player player, class_2338 pos, class_3414 sound, class_3419 category, float volume, float pitch) {
        class_1657 entity = player == null ? null : player.getEntity();
        world.method_8396((class_1297)entity, pos, sound, category, volume, pitch);
    }

    public static void playSound(class_1937 world, @Nullable Player player, class_2338 pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world, player, pos, sound.get(), category.get(), volume, pitch);
    }

    public static void playSound(class_1937 world, class_2338 pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world, null, pos, sound.get(), category.get(), volume, pitch);
    }

    public static void playSound(class_1937 world, double x, double y, double z, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch, boolean useDistance) {
        world.method_8486(x, y, z, sound.get(), category.get(), volume, pitch, useDistance);
    }

    public static void sendEntityStatus(class_1937 world, class_1297 entity, byte status) {
        world.method_8421(entity, status);
    }

    public static class_2338 getSpawnPos(class_1937 world) {
        return world.method_74854().method_74897();
    }

    public static Optional<MinecraftServer> getServer(class_1937 world) {
        if (WorldUtil.isClient(world)) {
            return Optional.empty();
        }
        return Optional.ofNullable(world.method_8503());
    }

    public static class_3218 getWorld(class_1937 world, class_2960 worldId) {
        Optional<MinecraftServer> server = WorldUtil.getServer(world);
        return server.map(minecraftServer -> WorldUtil.getWorld(minecraftServer, worldId)).orElse(null);
    }

    public static Optional<class_3218> getWorld(class_1937 world, CompatIdentifier worldId) {
        return Optional.ofNullable(WorldUtil.getWorld(world, worldId.toMinecraft()));
    }

    public static class_3218 getOverworld(MinecraftServer server) {
        return server.method_3847(class_1937.field_25179);
    }

    public static class_3218 getNether(MinecraftServer server) {
        return server.method_3847(class_1937.field_25180);
    }

    public static class_3218 getEnd(MinecraftServer server) {
        return server.method_3847(class_1937.field_25181);
    }

    public static class_3218 getWorld(MinecraftServer server, class_2960 worldId) {
        return server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldId));
    }

    public static class_3218 getWorld(MinecraftServer server, CompatIdentifier worldId) {
        return WorldUtil.getWorld(server, worldId.toMinecraft());
    }

    public static class_2960 getWorldId(class_1937 world) {
        return world.method_27983().method_29177();
    }

    public static CompatIdentifier getCompatWorldId(class_1937 world) {
        return CompatIdentifier.fromMinecraft(WorldUtil.getWorldId(world));
    }

    public static boolean equals(class_1937 world, class_1937 world2) {
        return Objects.equals(WorldUtil.getWorldId(world), WorldUtil.getWorldId(world2));
    }

    @Deprecated
    public static <T> void addTicket(class_3218 world, class_3230 type, class_1923 pos, int radius, T argument) {
        world.method_14178().method_66009(type, pos, radius);
    }

    @Deprecated
    public static <T> void removeTicket(class_3218 world, class_3230 type, class_1923 pos, int radius, T argument) {
        world.method_14178().method_66010(type, pos, radius);
    }

    public static <T> void addTicket(class_3218 world, ChunkTicketType<T> type, class_1923 pos, int radius, T argument) {
        WorldUtil.addTicket(world, type.getRaw(), pos, radius, argument);
    }

    public static <T> void removeTicket(class_3218 world, ChunkTicketType<T> type, class_1923 pos, int radius, T argument) {
        WorldUtil.removeTicket(world, type.getRaw(), pos, radius, argument);
    }

    public static void addTicket(class_3218 world, ChunkTicketType<?> type, class_1923 pos, int radius) {
        world.method_14178().method_66009(type.getRaw(), pos, radius);
    }

    public static void removeTicket(class_3218 world, ChunkTicketType<?> type, class_1923 pos, int radius) {
        world.method_14178().method_66010(type.getRaw(), pos, radius);
    }

    public static boolean isReceivingRedstonePower(class_1937 world, class_2338 pos) {
        return world.method_49803(pos);
    }

    public static int getBottomY(class_1937 world) {
        return world.method_31607();
    }

    public static int getTopY(class_1937 world) {
        return world.method_31600();
    }

    public static int getDimensionHeight(class_1937 world) {
        return world.method_8597().comp_652();
    }

    public static class_2586 getBlockEntity(class_1937 world, class_2338 pos) {
        return world.method_8321(pos);
    }

    public static boolean hasBlockEntity(class_1937 world, class_2338 pos) {
        return WorldUtil.getBlockEntity(world, pos) != null;
    }

    public static class_2680 getBlockState(class_1937 world, class_2338 pos) {
        return world.method_8320(pos);
    }

    public static class_3610 getFluidState(class_1937 world, class_2338 pos) {
        return world.method_8316(pos);
    }

    public static boolean hasFluidState(class_1937 world, class_2338 pos) {
        return !WorldUtil.getFluidState(world, pos).method_15769();
    }

    public static boolean isAir(class_1937 world, class_2338 pos) {
        return WorldUtil.getBlockState(world, pos).method_26215();
    }

    public static boolean setBlockState(class_1937 world, class_2338 pos, class_2680 state, int flags) {
        return world.method_8652(pos, state, flags);
    }

    public static boolean setBlockState(class_1937 world, class_2338 pos, class_2680 state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(class_1937 world, class_2338 pos, class_2248 block, int flags) {
        return WorldUtil.setBlockState(world, pos, block.method_9564(), flags);
    }

    public static boolean setBlockState(class_1937 world, class_2338 pos, class_2248 block) {
        return WorldUtil.setBlockState(world, pos, block, 3);
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos, boolean drop) {
        return world.method_22352(pos, drop);
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos) {
        return WorldUtil.breakBlock(world, pos, true);
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos, boolean drop, @Nullable Player player) {
        if (player == null) {
            return world.method_8651(pos, drop, null);
        }
        return world.method_8651(pos, drop, (class_1297)player.getPlayerEntity());
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos, @Nullable Player player) {
        return WorldUtil.breakBlock(world, pos, true, player);
    }

    public static void removeBlockEntity(class_1937 world, class_2338 pos) {
        world.method_8544(pos);
    }

    public static boolean removeBlock(class_1937 world, class_2338 pos, boolean move) {
        return world.method_8650(pos, move);
    }

    public static void addParticle(class_1937 world, class_2394 parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        world.method_8406(parameters, x, y, z, velocityX, velocityY, velocityZ);
    }

    public static boolean canSetBlock(class_1937 world, class_2338 pos) {
        return world.method_8628(class_2246.field_10340.method_9564(), pos, class_3726.method_16194());
    }

    public static void updateComparators(class_1937 world, class_2338 pos, class_2248 block) {
        world.method_8455(pos, block);
    }

    public static List<Player> getPlayers(class_1937 world) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (class_1657 player : world.method_18456()) {
            players.add(new Player(player));
        }
        return players;
    }

    public static Player getPlayer(class_1937 world, UUID uuid) {
        return new Player(world.method_18470(uuid));
    }

    public static CompatRandom getRandom(class_1937 world) {
        return new CompatRandom(world.method_8409());
    }

    public static long getTime(class_1937 world) {
        return world.method_8510();
    }

    public static <T extends class_1297> List<T> getEntitiesByType(class_1937 world, class_1299<T> filter, class_238 box, Predicate<? super T> predicate) {
        return world.method_18023(filter, box, predicate);
    }

    public static <T extends class_1297> List<T> getEntitiesByClass(class_1937 world, Class<T> entityClass, class_238 box, Predicate<? super T> predicate) {
        return world.method_8390(entityClass, box, predicate);
    }

    public static void spawnParticles(class_1937 world, class_2394 parameters, double x, double y, double z, int count, double velocityX, double velocityY, double velocityZ, double speed) {
        if (!WorldUtil.isServer(world)) {
            return;
        }
        ((class_3218)world).method_65096(parameters, x, y, z, count, velocityX, velocityY, velocityZ, speed);
    }

    public static void updateListeners(class_1937 world, class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {
        world.method_8413(pos, oldState, newState, flags);
    }

    public static BlockState getMidohraBlockState(class_1937 world, class_2338 pos) {
        return BlockState.of(WorldUtil.getBlockState(world, pos));
    }

    public static boolean setBlockState(class_1937 world, class_2338 pos, BlockState state, int flags) {
        return WorldUtil.setBlockState(world, pos, state.toMinecraft(), flags);
    }

    public static boolean setBlockState(class_1937 world, class_2338 pos, BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(class_1937 world, BlockPos pos, BlockState state, int flags) {
        return WorldUtil.setBlockState(world, pos.toMinecraft(), state.toMinecraft(), flags);
    }

    public static boolean setBlockState(class_1937 world, BlockPos pos, BlockState state) {
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean breakBlock(class_1937 world, BlockPos pos, boolean drop) {
        return WorldUtil.breakBlock(world, pos.toMinecraft(), drop);
    }

    public static boolean breakBlock(class_1937 world, BlockPos pos) {
        return WorldUtil.breakBlock(world, pos, true);
    }

    public static boolean breakBlock(class_1937 world, BlockPos pos, boolean drop, @Nullable Player player) {
        return WorldUtil.breakBlock(world, pos.toMinecraft(), drop, player);
    }

    public static boolean breakBlock(class_1937 world, BlockPos pos, @Nullable Player player) {
        return WorldUtil.breakBlock(world, pos, true, player);
    }

    public static void removeBlockEntity(class_1937 world, BlockPos pos) {
        WorldUtil.removeBlockEntity(world, pos.toMinecraft());
    }

    public static boolean removeBlock(class_1937 world, BlockPos pos, boolean move) {
        return WorldUtil.removeBlock(world, pos.toMinecraft(), move);
    }

    public static void playSound(World world, @Nullable Player player, BlockPos pos, CompatSoundEvent sound, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(world.getRaw(), player, pos.toMinecraft(), sound, category, volume, pitch);
    }

    public static void dropStackOnBlock(class_1937 world, class_2338 pos, class_1799 stack) {
        class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack);
    }

    public static float getSkyAngle(class_1937 world, float tickDelta) {
        return world.method_30274(tickDelta);
    }

    public static class_2248 getBlock(class_1937 world, class_2338 pos) {
        return WorldUtil.getBlockState(world, pos).method_26204();
    }

    public static BlockWrapper getBlockWrapper(class_1937 world, class_2338 pos) {
        return BlockWrapper.of(WorldUtil.getBlock(world, pos));
    }

    public static <T extends class_1297> List<T> getEntitiesByType(class_1937 world, class_1299<T> filter, class_238 box) {
        return WorldUtil.getEntitiesByType(world, filter, box, class_1301.field_6154);
    }

    public static <T extends class_1297> List<T> getEntitiesByType(class_1937 world, EntityTypeWrapper filter, class_238 box, Predicate<? super T> predicate) {
        return WorldUtil.getEntitiesByType(world, filter.get(), box, predicate);
    }

    public static List<?> getEntitiesByType(class_1937 world, EntityTypeWrapper filter, class_238 box) {
        return WorldUtil.getEntitiesByType(world, filter.get(), box);
    }

    public static CompatIdentifier getOverworldId() {
        return CompatIdentifier.fromMinecraft(class_1937.field_25179.method_29177());
    }

    public static CompatIdentifier getNetherId() {
        return CompatIdentifier.fromMinecraft(class_1937.field_25180.method_29177());
    }

    public static CompatIdentifier getEndId() {
        return CompatIdentifier.fromMinecraft(class_1937.field_25181.method_29177());
    }
}

